#include "AddressBook.h"

#include "Person.h"
#include "Organization.h"
#include "Connection.h"
#include "Groupware.h"
#include "Contact.h"
#include "Connection.h"
#include "ContactCategory.h"


AddressBook::~AddressBook() {
  while(_contacts.size()) {
    Contact *contact=_contacts.front();
    _contacts.pop_front();
    delete contact;
  }
  while(_connections.size()) {
    Connection* connection=_connections.front();
    _connections.pop_front();
    delete connection;
  }
}

Person* AddressBook::createPerson() {
  Person*person=new Person(this);
  _contacts.push_back(person);
  return person;
}

Organization* AddressBook::createOrganization() {
  Organization*organization=new Organization(this);
  _contacts.push_back(organization);
  return organization;
}

void AddressBook::removeContact(Contact *contact) {
  _contacts.remove(contact);
}

Connection *AddressBook::createConnection(Contact *from,Contact *to) {
  Connection*connection=new Connection(this,from,to);
  _connections.push_back(connection);
  return connection;
}

void AddressBook::removeConnection(Connection *connection) {
  _connections.remove(connection);
}

ContactCategory* AddressBook::createContactCategory() {
  ContactCategory*category=new ContactCategory(this);
  _contactCategories.push_back(category);
  return category;
}

void AddressBook::removeContactCategory(ContactCategory*category) {
  _contactCategories.remove(category);
}

