#ifndef AddressBook_h
#define AddressBook_h

#include <list>
#include <string>
using namespace std;

//forward declaration 
class Groupware;
class Person;
class Organization;
class Contact;
class Connection;
class ContactCategory;

class AddressBook {
public:
  AddressBook (Groupware *groupware):_groupware(groupware) {}
  virtual ~AddressBook();
public:
  virtual Groupware *groupware() const { return _groupware; }
  virtual Person* createPerson();
  virtual Organization* createOrganization();
  virtual void removeContact(Contact *);
  virtual Connection *createConnection(Contact*from,Contact*to);
  virtual void removeConnection(Connection *connection);
  virtual ContactCategory* createContactCategory();
  virtual void removeContactCategory(ContactCategory*category);
private:
  Groupware *_groupware;
  list<Contact*> _contacts;
  list<Connection*> _connections;
  list<ContactCategory*> _contactCategories;
};

#endif 
