#ifndef Contact_h
#define Contact_h

#include <list>
#include <string>
using namespace std;

//forward declarations
class Function; 
class Address;
class EMailAddress;
class IMAddress;
class TelephoneNumber;
class MailAddress;
class ContactCategory;
class AddressBook;
class WebAddress;

class Contact { //abstract
public:
  Contact(AddressBook *addressBook):_addressBook(addressBook),_category(0) {}
  virtual ~Contact ();
  virtual string name() const { return _name; }
  virtual void setName(string name) { _name=name; }
  virtual Function* createFunction();
  virtual void removeFunction(Function *function);
  virtual EMailAddress* createEMailAddress();
  virtual IMAddress* createIMAddress();
  virtual MailAddress* createMailAddress();
  virtual TelephoneNumber* createTelephoneNumber();
  virtual WebAddress* createWebAddress();
  virtual void removeAddress(Address *address);
  virtual ContactCategory* category() { return _category; }
  virtual void setContactCategory(ContactCategory *category) { _category=category; }
private:
  AddressBook* _addressBook;
  string _name;
  list<Function*> _functions;
  list<Address*>  _addresses;
  ContactCategory* _category;
};

#endif 
