#ifndef Groupware_h
#define Groupware_h

#include "Person.h"
#include "Organization.h"
#include "EMailAddress.h"
#include "MailAddress.h"
#include "WebAddress.h"
#include "IMAddress.h"
#include "AddressBook.h"
#include "ContactCategory.h"
#include "TelephoneNumber.h"
#include "Function.h"
#include "Connection.h"

class Groupware { // singelton pattern
public:
  Groupware();
  virtual ~Groupware();
  virtual AddressBook*addressBook() const { return _addressBook; }
private:
  AddressBook *_addressBook;
public:
  static Groupware* instance() {
    if(!_instance) {
      _instance=new Groupware();
    }
    return _instance;
  }
  static void cleanup() {
    if(_instance) {
      delete _instance;
      _instance=0;
    }
  }
private:
  static Groupware* _instance;
};

#endif 
