#include "Groupware.h"
#include "Person.h"
#include "Organization.h"
#include "EMailAddress.h"
#include "MailAddress.h"
#include "WebAddress.h"
#include "IMAddress.h"
#include "AddressBook.h"
#include "ContactCategory.h"
#include "TelephoneNumber.h"
#include "Function.h"
#include "Connection.h"

int main(int argc,char *argv[]) {
  Groupware *groupware=Groupware::instance();
  AddressBook*addressBook=groupware->addressBook();

  ContactCategory* freunde=addressBook->createContactCategory();
  freunde->setName("Freunde");

  Person*person=addressBook->createPerson();
  person->setName("Mueller");
  person->setGivenName("Hans");
  person->setSalutation("Hallo");

  person->setContactCategory(freunde);

  MailAddress*mailAddress=person->createMailAddress();
  mailAddress->setFunction("Uni-Anschrift");
  mailAddress->setStreet("Ehrenbergstrasse 78");
  mailAddress->setCity("Ilmenau");
  mailAddress->setCountry("Deutschland");
  mailAddress->setZipcode("82833");

  WebAddress*webAddress=person->createWebAddress();
  webAddress->setFunction("Eigene Homepage");
  webAddress->setUrl("http://www.hansimuellerswelt.de");

  webAddress=person->createWebAddress();
  webAddress->setFunction("Uni-Seite");
  webAddress->setUrl("http://www.uni-ilmenau.de/~hansmueller");

  TelephoneNumber* tel=person->createTelephoneNumber();
  tel->setFunction("zu Hause");
  tel->setNumber("+49=3232-23232");
  tel=person->createTelephoneNumber();
  tel->setFunction("Mobil");
  tel->setNumber("+49=179-2323232");
  tel->setSMS(true);

  Function* function=person->createFunction();
  function->setName("Adminitrator von hansimuellerswelt");

  function=person->createFunction();
  function->setName("Schulfreund");

  Organization*organization=addressBook->createOrganization();
  organization->setName("Uni Ilmenau");

  mailAddress=organization->createMailAddress();
  mailAddress->setFunction("Lieferanschrift");
  mailAddress->setStreet("Helmholzring 23");
  mailAddress->setCity("Ilmenau");
  mailAddress->setCountry("Deutschland");
  mailAddress->setZipcode("29322");

  organization->addMember(person);

  Connection *connection=addressBook->createConnection(person,organization);
  connection->setName("Student an");

  return 0;

}
