#include "ImageWidget.h"
#include <qpainter.h>

ImageWidget::ImageWidget(QImage img, QWidget *parent, const char *name)
  :QWidget(parent, name) {
    setImage(img);
}

void ImageWidget::setImage(QImage img) {
  image=img;
  if(img.isNull()) 
    aspectRatio = 0;
  else {
    drawImg.convertFromImage(img);
    aspectRatio = img.width() / img.height();

    this->setMinimumSize(img.width(), img.height());
  }

  repaint();
}

void ImageWidget::paintEvent( QPaintEvent *e ) {
  if(!image.isNull()) {
    QPainter painter(this);
    if ( image.size() != QSize( 0, 0 ) ) {      
      //painter.setClipRect(e->rect());
      painter.drawPixmap(0, 0, image);
    }
  }
}

void ImageWidget::resizeEvent( QResizeEvent *e ) {
 /* if(!image.isNull()) {
    int w = this->width();
    float h = w/aspectRatio;
    image.smoothScale(w,(int)h);
    drawImg.convertFromImage(image);
  }
  */
}
