
#include "QTclHistoViewer.h"
#include "ImageWidget.h"

#include <qpushbutton.h>
#include <qapplication.h>
#include <qstring.h>
#include <qfiledialog.h>
#include <qpainter.h>
#include <qcolor.h>
#include <qwidget.h>
#include <qlayout.h>

#include <iostream>
#include <math.h>


using namespace std;

QTclHistoViewer::QTclHistoViewer(QWidget *parent, const char *name):QWidget(parent, name) {//,hWidth(256), hHeight(512) {
  this->setMinimumSize(400,400);
  this->setGeometry(50,50,600,600);
  
  showHistoB = NULL;
  showHisto = true;

  initGUI();
  cout << "viewer constructed ..." << endl;
}

/**
* erstelle und initialisiere gui
*
*/
void QTclHistoViewer::initGUI() {
  QBoxLayout *layout1 = new QBoxLayout(this, QBoxLayout::TopToBottom);
  QBoxLayout *layout2 = new QBoxLayout(QBoxLayout::LeftToRight);
  QBoxLayout *layout3 = new QBoxLayout(QBoxLayout::LeftToRight);

  layout1->addLayout(layout2);
  layout1->addLayout(layout3);


  QPushButton *quit = new QPushButton("Quit", this, "top.quit");
  quit->setMinimumSize(60,25);
  quit->setMaximumSize(60,25);
  //quit->setGeometry(1,1,60,25);

  QPushButton *load = new QPushButton("Load", this, "top.load");
  //load->setGeometry(65,1,60,25);
  load->setMinimumSize(60,25);
  load->setMaximumSize(60,25);

  showHistoB = new QPushButton("Hide Histogram", this, "top.showHisto");
  //showHistoB->setGeometry(130,1,140,25);
  showHistoB->setMinimumSize(140,25);
  showHistoB->setMaximumSize(140,25);

  layout2->addWidget(quit,0);
  layout2->addWidget(load,0);
  layout2->addWidget(showHistoB,0);
  layout2->addWidget(new QWidget(this)); //dummy

  imgW1 = new ImageWidget(0,this,"top.imgW1");
  imgW2 = new ImageWidget(0,this,"top.imgW2");

  layout3->addWidget(imgW1);
  layout3->addWidget(imgW2);

  //doing connections
  connect( quit, SIGNAL(clicked()), qApp, SLOT(quit()) );
  connect( load, SIGNAL(clicked()), this, SLOT(openFile()) );
  connect( showHistoB, SIGNAL(clicked()), this, SLOT(switchHistoShowing()) );
}

/**
*
*/
void QTclHistoViewer::setHistoShowing(bool show) {
  showHisto = show;
  if(showHisto) {
    showHistoB->setText("Hide Histogram");
    imgW2->show();
  }
  else {
    showHistoB->setText("Show Histogram");
    imgW2->hide();
  }

  repaint();
}

/**
*
*/
void QTclHistoViewer::switchHistoShowing() {
  setHistoShowing(!showHisto);
}

/**
*
*/
void QTclHistoViewer::openFile() {
  filename = QFileDialog::getOpenFileName( QString::null,
                                           QString::null,
                                           this, 0, "open image" );
  if ( !filename.isEmpty() ) {
    loadImage( filename ) ;         //lade bild
    repaint();                      //widget neuzeichnen
    setHistoShowing(true);
  }
}

/**
*
*/
bool QTclHistoViewer::loadImage(const QString &filename) {
  if(filename.isEmpty()) return false;

  //lade bild
  image.reset();
  image.load(filename);
  if(image.isNull()) {
    cout << "error: selected file is not a image file ..." << endl;
    return false;
  }
  else if(!image.allGray()) {
    cout << "error: selected file is not a grayscale image ..." << endl;
    return false;
  }
  
  //crating histogram
  createhistogram();

  imgW1->setImage(image);
  //erstelle pixmap
  cout << filename << " succesfully loaded ..." << endl;
  return true;
}

/**
*
*/
void QTclHistoViewer::createhistogram() {  
  initHistoArray();

  int width = image.width();
  int height = image.height();
  double addvalue = 1 / ((double)width*height); //Normierung

  for(int i=0; i<width; i++) {
    for(int j=0; j<height; j++) {
      QColor *current = new QColor(image.pixel(i,j));
      histoArray[current->red()] +=addvalue;
    }
  }
  
  //suche nach max
  double maxGW = histoArray[0];
  for(int i=1; i<256; i++) {
    if(histoArray[i] > maxGW)
      maxGW = histoArray[i];
  }

  
  for(int i=0; i<256; i++) {
    //histoArray[i] = floor(histoArray[i] * 512 / maxGW);
    histoArray[i] = (histoArray[i] * 512 / maxGW);
  }
  

  /*
  for(int i=0; i<256; i++)
    printf("%i: %f \n", i, histoArray[i]);
    //cout << i << ": " << histoArray[i] << endl;
  */

  cout << "histogram calculated ..." << endl; 
  createhistogramImage();
}

/**
*
*/
void QTclHistoViewer::createhistogramImage() {
  histogram.reset();


  //init pixData to black
  for(int i=0; i<hWidth*hHeight; i++) {
        pixData[i] = 0;
  }

  for(int i=0; i<hWidth; i++) {
    int value = (int) histoArray[i];
    for(int j=0; j<=value; j++) {
      pixData[i+hWidth*j]=255;
    }
  }

  //creating image
  histogram.create(hWidth,hHeight,8,256);
  for ( int i = 0 ; i < 256 ; i++ ) histogram.setColor( i , qRgb(i,i,i) );
  memcpy( histogram.bits() , pixData , hWidth*hHeight );

  //rotating image
  histogram = histogram.mirror(false,true);
  
  //check
  if(!histogram.isNull()) {
    imgW2->setImage(histogram);
  }
  else
    cout << "error creating histogram image in createhistogramImage() ..." << endl;
}

/**
*
*/
void QTclHistoViewer::initHistoArray() {
  for(int i=0; i<hWidth; i++)
    histoArray[i] = 0;
}

/**
*

void QTclHistoViewer::paintEvent(QPaintEvent *e) {
  QPainter painter(this);
  if ( pixmap.size() != QSize( 0, 0 ) ) {         //kleiner sicherheitscheck
      //painter.setClipRect(e->rect());
      painter.drawPixmap(0, 30, pixmap);
  }

  if ( pixmaphistogram.size()!= QSize( 0, 0 ) && showHisto)
    painter.drawPixmap(pixmap.width()+10, 30, pixmaphistogram);
}
*/
