#ifndef MYIMGVIEWER
#define MYIMGVIEWER

#include <qwidget.h>
#include <qimage.h>
#include <qpixmap.h>

class QPushButton;
class ImageWidget;

class QTclHistoViewer : public QWidget {
  Q_OBJECT
  Q_PROPERTY( bool showHisto READ isHistoShowing WRITE setHistoShowing)
public:
  QTclHistoViewer(QWidget *parent=0,const char *name=0);
  bool isHistoShowing() const {return showHisto;}

protected:
  //void paintEvent( QPaintEvent *e );
  //void resizeEvent( QResizeEvent *e );

private:
  QString   filename;               // die geladene Datei
  QImage    image;                  // das bild

  QImage    histogram;
  double    histoArray[256];        // hier kommen die histo infos rein
  static const int  hWidth = 256;   // Dimension des histograms
  static const int  hHeight = 512;
  unsigned char pixData[hWidth*hHeight];

  bool      showHisto;
  QPushButton *showHistoB;

  ImageWidget *imgW1;
  ImageWidget *imgW2;

private:
  void initGUI();
  bool loadImage(const QString &filename);
  void createhistogram();
  void createhistogramImage();
  void initHistoArray();

public slots:
  void openFile();
  void setHistoShowing(bool show);
  void switchHistoShowing();
};

#endif //MYIMGVIEWER
