#ifndef _PongModel_h
#define _PongModel_h

#include <QtGui>

class PongModel : public QObject {
  Q_OBJECT
  Q_PROPERTY(double ballX READ ballX WRITE setBallX NOTIFY pongChanged )
  Q_PROPERTY(double ballY READ ballY WRITE setBallY NOTIFY pongChanged )
  Q_PROPERTY(double ballR READ ballR WRITE setBallR NOTIFY pongChanged )
  Q_PROPERTY(double ballVX READ ballVX WRITE setBallVX)
  Q_PROPERTY(double ballVY READ ballVY WRITE setBallVY)
public:
  PongModel(QObject *parent): QObject(parent),_ballX(0),_ballY(0),_ballR(0.02),_ballVX(0),_ballVY(0) {
    startTimer(100);
  }
  virtual ~PongModel() {}
public:
  virtual double ballX() const { return _ballX; }
  virtual double ballY() const { return _ballY; }
  virtual double ballR() const { return _ballR; }
  virtual double ballVX() const { return _ballVX; }
  virtual double ballVY() const { return _ballVY; }
signals:
  void pongChanged();
public slots:
  virtual void setBallX(double x) {
    if(_ballX!=x) {
      _ballX=x; 
      emit pongChanged();
    }
  }
  virtual void setBallY(double y) {
    if(_ballY!=y) {
      _ballY=y; 
      emit pongChanged();
    }
  }
  virtual void setBallR(double r) {
    if(_ballR!=r) {
      _ballR=r; 
      emit pongChanged();
    }
  }
  virtual void setBallVX(double vx) {
    if(_ballVX!=vx) {
      _ballVX=vx; 
    }
  }
  virtual void setBallVY(double vy) {
    if(_ballVY!=vy) {
      _ballVY=vy; 
    }
  }
protected:
  virtual void timerEvent(QTimerEvent *event) {
    Q_UNUSED(event);
    double newBallX=_ballX+_ballVX;
    double newBallY=_ballY+_ballVY;
    if(newBallX<0 || newBallX>1) {
      _ballVX=-_ballVX;
    }
    if(newBallY<0 || newBallY>1) {
      _ballVY=-_ballVY;
    }
    setBallX(newBallX);
    setBallY(newBallY);
  }
private:
  double _ballX;
  double _ballY;
  double _ballR;
  double _ballVX;
  double _ballVY;
};

#endif
