#ifndef _PongView_h
#define _PongView_h

#include <QtGui>

#include "PongModel.h"

class PongView : public QWidget {
  Q_OBJECT
public:
  PongView(QWidget *parent): QWidget(parent),_model(0),_moving(false) {
    setStyleSheet("* { background: black; }");
  }
  virtual ~PongView() {}
public slots:
  virtual void pongChanged() {
    update();
  }
  virtual void setPongModel(PongModel *model) {
    _model=model; 
    if(_model) {
      connect(_model,SIGNAL(pongChanged()),this,SLOT(pongChanged()));
      connect(_model,SIGNAL(destroyed()),this,SLOT(pongModelDestroyed()));
    }
    update();
  }
  virtual void pongModelDestroyed() {
    _model=0;
    update();
  }
protected:
  virtual void paintEvent(QPaintEvent *event) {
    Q_UNUSED(event);
    if(!_model) return;
    QPainter painter(this);
    int x=m2vx(_model->ballX());
    int y=m2vy(_model->ballY());
    int r=m2vx(_model->ballR());
    if(_moving) {
      painter.setPen(Qt::red);
    } else {
      painter.setPen(Qt::white);
    }
    painter.setBrush(Qt::black);
    painter.drawEllipse(x-r,y-r,2*r,2*r);
  }
  virtual void mousePressEvent(QMouseEvent *event) {
    if(!_model) return;
    if (!event->button()==Qt::LeftButton) return;
    if(
        (  event->pos()-
           QPoint(
            m2vx(_model->ballX()),
            m2vy(_model->ballY())
           )
        ).manhattanLength()<QApplication::startDragDistance()
      ) {
       _moving=true;
       update();
     }
  }
  virtual void mouseMoveEvent(QMouseEvent *event) {
    if(!_model) return;
    if(!_moving) return;
    QPoint p=event->pos();
    _model->setBallX(v2mx(p.x()));
    _model->setBallY(v2my(p.y()));
  }
  virtual void mouseReleaseEvent(QMouseEvent *event) {
    if (!event->button()==Qt::LeftButton) return;
    _moving=false;
    update();
  }
protected:
  virtual int m2vx(double mx) { return mx*width(); }
  virtual int m2vy(double my) { return my*height(); }
  virtual double v2mx(int x) { return (double)(x)/width(); }
  virtual double v2my(int y) { return (double)(y)/height(); }
private:
  PongModel* _model;
  bool    _moving;
};

#endif
