<?php
/***************************************************************
*  Copyright notice
*  
*  (c) 2002 Thomas Schulze (t.schulze@outraxx.de)
*  (c) 2005 Sven Schaepe (schaepe@bj-ig.de)
*  All rights reserved
*
*  This script is part of the Typo3 project. The Typo3 project is 
*  free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
* 
*  The GNU General Public License can be found at
*  http://www.gnu.org/copyleft/gpl.html.
* 
*  This script is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  This copyright notice MUST APPEAR in all copies of the script!
***************************************************************/
/** 
 * Module 'Publish' for the 'publish' extension.
 *
 * @author	Thomas Schulze <t.schulze@outraxx.de>
 * @author	Sven Schaepe <schaepe@bj-ig.de>
 */



	// DEFAULT initialization of a module [BEGIN]
unset($MCONF);	
include ("conf.php");
include ($BACK_PATH."init.php");
include ($BACK_PATH."template.php");
include ("locallang.php");
include_once(PATH_t3lib."class.t3lib_scbase.php");
include_once(PATH_t3lib."class.t3lib_div.php");

$BE_USER->modAccess($MCONF,1);	// This checks permissions and exits if the users has no permission for entry.
	// DEFAULT initialization of a module [END]

class tx_publish2static_module1 extends t3lib_SCbase {
	var $pageinfo;

	/**
	 * 
	 */
	function init()	{
		global $AB,$BE_USER,$LANG,$BACK_PATH,$TCA_DESCR,$TCA,$HTTP_GET_VARS,$HTTP_POST_VARS,$CLIENT,$TYPO3_CONF_VARS;
		
		parent::init();

		/*
		if (t3lib_div::GPvar("clear_all_cache"))	{
			$this->include_once[]=PATH_t3lib."class.t3lib_tcemain.php";
		}
		*/
	}

	/**
	 * Adds items to the ->MOD_MENU array. Used for the function menu selector.
	 */
	function menuConfig()	{
		global $LANG;
		$this->MOD_MENU = Array (
			"function" => Array (
				"1" => $LANG->getLL("createStatic"),
				"2" => $LANG->getLL("ftpTransfer"),
				"3" => $LANG->getLL("cleanUpFileadmin"),
			)
		);
		parent::menuConfig();
	}

		// If you chose "web" as main module, you will need to consider the $this->id parameter which will contain the uid-number of the page clicked in the page tree
	/**
	 * Main function of the module. Write the content to $this->content
	 */
	function main()	{
		global $AB,$BE_USER,$LANG,$BACK_PATH,$TCA_DESCR,$TCA,$HTTP_GET_VARS,$HTTP_POST_VARS,$CLIENT,$TYPO3_CONF_VARS;
		
		// Access check!
		// The page will show only if there is a valid page and if this page may be viewed by the user
		$this->pageinfo = t3lib_BEfunc::readPageAccess($this->id,$this->perms_clause);
		$access = is_array($this->pageinfo) ? 1 : 0;
		
		if (($this->id && $access) || ($BE_USER->user["admin"] && !$this->id))	{
	
				// Draw the header.
			$this->doc = t3lib_div::makeInstance("mediumDoc");
			$this->doc->backPath = $BACK_PATH;
			$this->doc->form='<form action="" method="POST">';

				// JavaScript
			$this->doc->JScode = '
				<script language="javascript">
					script_ended = 0;
					function jumpToUrl(URL)	{
						document.location = URL;
					}
				</script>
			';
			$this->doc->postCode='
				<script language="javascript">
					script_ended = 1;
					if (top.theMenu) top.theMenu.recentuid = '.intval($this->id).';
				</script>
			';

			//$headerSection = $this->doc->getHeader("pages",$this->pageinfo,$this->pageinfo["_thePath"])."<br>".$LANG->php3Lang["labels"]["path"].": ".t3lib_div::fixed_lgd_pre($this->pageinfo["_thePath"],50);

			$this->content.=$this->doc->startPage($LANG->getLL("title"));
			$this->content.=$this->doc->header($LANG->getLL("title"));
			$this->content.=$this->doc->spacer(5);
			$this->content.=$this->doc->section("",$this->doc->funcMenu($headerSection,t3lib_BEfunc::getFuncMenu($this->id,"SET[function]",$this->MOD_SETTINGS["function"],$this->MOD_MENU["function"])));
			$this->content.=$this->doc->divider(5);

			
			// Render content:
			$this->moduleContent();

			
			
		
			$this->content.=$this->doc->spacer(10);
		} else {
				// If no access or if ID == zero
		
			$this->doc = t3lib_div::makeInstance("mediumDoc");
			$this->doc->backPath = $BACK_PATH;
		
			$this->content.=$this->doc->startPage($LANG->getLL("title"));
			$this->content.=$this->doc->header($LANG->getLL("title"));
			$this->content.=$this->doc->spacer(5);
			$this->content.=$this->doc->spacer(10);
		}
	}

	/**
	 * Prints out the module HTML
	 */
	function printContent()	{
		global $SOBE;

		$this->content.=$this->doc->middle();
		$this->content.=$this->doc->endPage();
		echo $this->content;
	}
	
	/**
	 * Generates the module content
	 */
	function moduleContent()	{
		global $LANG,$SEPARATOR;
		$publishConfig = unserialize($GLOBALS["TYPO3_CONF_VARS"]["EXT"]["extConf"]["publish2static"]);
		$win=strpos($publishConfig["wgetPath"],".exe");
		if($win==false) {
		    $sep=$SEPARATOR[unix];
		} else {
		    $sep=$SEPARATOR[win];
		}
		$function=t3lib_div::GPvar("function");
		if(!isset($function)) {
		    $function=$this->MOD_SETTINGS["function"];
		}
		switch((string)$function)	{
			case 1: // build static pages
				$qs="select * from sys_domain where hidden=0";  // Welche Projekte knnen publisht werden ?
				$projekt = mysql(TYPO3_db,$qs);
				if(mysql_num_rows($projekt)) {
					$content.=$LANG->getLL("createStaticInfo");
					$wget=$publishConfig["wgetPath"]." -V";
					exec($wget,$out,$error);
					if(!$error) {
					    while($row = mysql_fetch_assoc($projekt)) {
						    $content.="<a href='publish.php?id=".$row["pid"]."&domain=".$row["domainName"]."&sep=".$sep."'><b>".$LANG->getLL("start")."(".$row["domainName"].")</b></a><BR>";
					    }
					} else {
					    $content.="<br><br><b><font color=red>".$LANG->getLL("wgetFailed")."</font></b><br>";
					}
					$this->content.=$this->doc->section($LANG->getLL("headline"),$content,0,1);
				} else {
					$content.=$LANG->getLL("reason");
					$this->content.=$this->doc->section($LANG->getLL("cantCreate"),$content,0,1);
				}
				break;
			case 2: // ftp
				$qs="select * from sys_domain where hidden=0";  // Welche Projekte knnen bertragen werden ?
				$projekt = mysql(TYPO3_db,$qs);
				if(mysql_num_rows($projekt)) {
					$content.=$LANG->getLL("createTransferInfo");
					while($row = mysql_fetch_assoc($projekt)) {
						$verz=$row["domainName"];	
						$path="../../../../fileadmin/".$verz."/static/";
						$filesInDir = t3lib_div::getFilesInDir($path,"html",0,1);
						if(count($filesInDir))	{
							$content.="<a href='".$path."' target='_blank'><b>".$LANG->getLL("viewStatic")."(".$row["domainName"].")</b></a><br>";
							$t=1;
							if(!$row["tx_publish2static_ftp"] or !$row["tx_publish2static_user"] or !$row["tx_publish2static_pass"]) {
								$t="";
							}
							if($t) {
								$content.="<a href='transfer.php?id=".$row["uid"]."&domain=".$row["domainName"]."&sep=".$sep."'><b>".$LANG->getLL("start")."(".$row["domainName"].")</b></a><br>";
							}
							else {
								$content.="<BR><BR><font color=red>".$LANG->getLL("domainFailed").":&nbsp;".$row["domainName"]."</font><BR>";
							}
						} else {
						    $content.="<b>".$row["domainName"].":</b><br><br><font color=red>".$LANG->getLL("transerror")."</font><br><br>";
						    if($publishConfig["verbose"]) {
							$content.=$LANG->getLL("noFile").$path." !<br>";
						    }
						}
					}
				}
				$this->content.=$this->doc->section($LANG->getLL("ftp"),$content,0,1);
				break;
			case 3: // cleanup
				$qs="select * from sys_domain where hidden=0";
				$projekt = mysql(TYPO3_db,$qs);
				if(mysql_num_rows($projekt)) {
					$content.=$LANG->getLL("createCleanUpInfo");
					while($row = mysql_fetch_assoc($projekt)) {
						$content.="<a href='publish.php?domain=".$row["domainName"]."&sep=".$sep."&cleanup=1"."'><b>".$LANG->getLL("cleanup")."(".$row["domainName"].")</b></a><br>";
					}
					$this->content.=$this->doc->section($LANG->getLL("cleanUpFileadmin"),$content,0,1);
				} else {
					$content.=$LANG->getLL("reason");
					$this->content.=$this->doc->section($LANG->getLL("cantCreate"),$content,0,1);
				}
				break;
		}
	}
}



if (defined("TYPO3_MODE") && $TYPO3_CONF_VARS[TYPO3_MODE]["XCLASS"]["ext/publish2static/mod1/index.php"])	{
	include_once($TYPO3_CONF_VARS[TYPO3_MODE]["XCLASS"]["ext/publish2static/mod1/index.php"]);
}




// Make instance:
$SOBE = t3lib_div::makeInstance("tx_publish2static_module1");
$SOBE->init();

// Include files?
reset($SOBE->include_once);	
while(list(,$INC_FILE)=each($SOBE->include_once))	{include_once($INC_FILE);}

$SOBE->main();
$SOBE->printContent();

?>
