<?php
/***************************************************************
*  Copyright notice
*  
*  (c) 2002  (Thomas Schulze <t.schulze@outraxx.de> www.outraxx.de)
*  (c) 2005 Sven Schaepe (schaepe@bj-ig.de)
*  All rights reserved
*
*  This script is part of the Typo3 project. The Typo3 project is 
*  free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
* 
*  The GNU General Public License can be found at
*  http://www.gnu.org/copyleft/gpl.html.
* 
*  This script is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  This copyright notice MUST APPEAR in all copies of the script!
***************************************************************/
/** 
 * ftp-transfer module mod1
 *
 * @author	Thomas Schulze <t.schulze@outraxx.de>
 * @author	Sven Schaepe <schaepe@bj-ig.de>
 */


	// DEFAULT initialization of a module [BEGIN]
unset($MCONF);	

include ("conf.php");
include ($BACK_PATH."init.php");
include ($BACK_PATH."template.php");
include ("locallang.php");
include_once(PATH_t3lib."class.t3lib_scbase.php");
include_once(PATH_t3lib."class.t3lib_div.php");

	// ....(But no access check here...)
	// DEFAULT initialization of a module [END] 

class tx_publish2static_module1 extends t3lib_SCbase {
	
	/**
	 * Main function of the module. Write the content to $this->content
	 */
	function main()	{
		global $AB,$BE_USER,$LANG,$BACK_PATH,$TCA_DESCR,$TCA,$HTTP_GET_VARS,$HTTP_POST_VARS,$CLIENT,$TYPO3_CONF_VARS;
		
			// Draw the header.
		$this->doc = t3lib_div::makeInstance("mediumDoc");
		$this->doc->backPath = $BACK_PATH;
		

		$this->pageinfo = t3lib_BEfunc::readPageAccess($this->id,$this->perms_clause);
		$access = is_array($this->pageinfo) ? 1 : 0;
		if (($this->id && $access) || ($BE_USER->user["admin"] && !$this->id))	{
			if ($BE_USER->user["admin"] && !$this->id)	{
				$this->pageinfo=array("title" => "[root-level]","uid"=>0,"pid"=>0);
			}

			//$headerSection = $this->doc->getHeader("pages",$this->pageinfo,$this->pageinfo["_thePath"])."<br>".$LANG->php3Lang["labels"]["path"].": ".t3lib_div::fixed_lgd_pre($this->pageinfo["_thePath"],50);

			$this->content.=$this->doc->startPage($LANG->getLL("process"));
			$this->content.=$this->doc->header($LANG->getLL("process"));
			$this->content.=$this->doc->spacer(5);
			//$this->content.=$this->doc->section("",$this->doc->funcMenu($headerSection,t3lib_BEfunc::getFuncMenu($this->id,"SET[function]",$this->MOD_SETTINGS["function"],$this->MOD_MENU["function"])));
			$this->content.=$this->doc->divider(5);

				
			// Render content:
			//$this->moduleContent();

			
		}				
		$this->content.=$this->doc->spacer(10);
	}
	function printContent()	{
		global $SOBE;

		$this->content.=$this->doc->middle();
		$this->content.=$this->doc->endPage();
		echo $this->content;
		$this->moduleContent();
	}
	
	function moduleContent(){
				global $LANG,$sdir;
				$id=t3lib_div::GPvar("id");
				$domain=t3lib_div::GPvar("domain");

				$publishConfig = unserialize($GLOBALS["TYPO3_CONF_VARS"]["EXT"]["extConf"]["publish2static"]);
				// FTP-Daten aus Domain holen
				$qs="select * from sys_domain where uid=$id";
				$ddata = mysql(TYPO3_db,$qs);
				if(mysql_num_rows($ddata)!=0) {
					while($access = mysql_fetch_assoc($ddata)) {
						$host=$access["tx_publish2static_ftp"];
						$user=$access["tx_publish2static_user"];
						$pass=$access["tx_publish2static_pass"];
						$sdir=$access["tx_publish2static_root"];
					}
				}
				if($publishConfig["verbose"]) {
					echo "hallo: ".$user.":".$pass."@".$host.":".$sdir."<br>";
				}
				// FTP-Login
				if(!$stream=ftp_connect ($host,21)) {
					echo "<br><b><font color=red>".$LANG->getLL("ftpConnectFailed")."</font></b>";
					flush();
					die();
				}
				if(!@ftp_login($stream, "$user", "$pass")) {
					echo "<br><b><font color=red>".$LANG->getLL("ftpLoginFailed")."</font></b>";
					flush();
					die();
				}
				else {
					echo $LANG->getLL("ftpLogedIn")."</b>".$user."<b><font color=green>&nbsp;OK</font></b><br>";
					flush();
				}
				if(!@ftp_chdir ($stream, $sdir)) {
					echo $LANG->getLL("ftpChdir")."</b>".$sdir."<b><font color=red>&nbsp;".$LANG->getLL("failed")."</font></b><br>";
					flush();
					die();
				}
				$verz=$domain;
				$startdir="../../../../fileadmin/".$verz."/static/";
				echo "<b>&nbsp;Starte die Datenbertragung<BR><BR>";
				$res=$this->ftp_copy($startdir,$sdir,$stream);
				echo "<HR><BR><BR><BR><BR>&nbsp;<b><a href='index.php'>".$LANG->getLL("back")."</a></b><BR><BR>";

				
	}

function ftp_copy($src_dir, $dst_dir, $conn_id) {
	$d = dir($src_dir);
	while($file = $d->read()) {
		if ($file != "." && $file != "..") {
			if (is_dir($src_dir."/".$file)) {
				if (!@ftp_chdir($conn_id, $file)) {
					echo "<BR>&nbsp;Verzeichnis $file existiert nicht... wird angelegt:";
					flush();
					if(@ftp_mkdir($conn_id, $file)) {
						echo "<font color=green> OK!</font><BR><BR>";
						@ftp_chdir($conn_id, $file);
					}
					else {
						echo "<font color=red> FEHLER!</font><BR><BR>";
					}
					flush();
				}
				$this->ftp_copy($src_dir."/".$file, $dst_dir."/".$file,$conn_id);
			}
			else {
				//if(ftp_size($conn_id, "$dst_dir/$file") != filesize ("$src_dir/$file")) {
				//	@ftp_delete($conn_id, "$dst_dir/$file");
				//}
				echo "&nbsp;Kopiere $src_dir/$file ...:";
				flush();
				if(@ftp_put($conn_id, $file, $src_dir."/".$file, FTP_BINARY)) {
					echo "<font color=green> OK!</font><BR>";
				}
				else {
					echo "<font color=red> FEHLER!</font><BR>";
				}
				flush();
			}
		}
	}
	@ftp_cdup($conn_id);
	$d->close();
}

}
if (defined("TYPO3_MODE") && $TYPO3_CONF_VARS[TYPO3_MODE]["XCLASS"]["ext/publish2static/mod1/transfer.php"])	{
	include_once($TYPO3_CONF_VARS[TYPO3_MODE]["XCLASS"]["ext/publish2static/mod1/transfer.php"]);
}




// Make instance:
$SOBE = t3lib_div::makeInstance("tx_publish2static_module1");
$SOBE->init();


$SOBE->main();
$SOBE->printContent();

?>
