<?php
/***************************************************************
*  Copyright notice
*  
*  (c) 2005 Sven Schaepe (schaepe@bj-ig.de)
*  All rights reserved
*
*  This script is part of the Typo3 project. The Typo3 project is 
*  free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
* 
*  The GNU General Public License can be found at
*  http://www.gnu.org/copyleft/gpl.html.
* 
*  This script is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  This copyright notice MUST APPEAR in all copies of the script!
***************************************************************/
/** 
 * publish module mod1
 *
 * @author        Sven Schaepe <schaepe@bj-ig.de>
 */



        // DEFAULT initialization of a module [BEGIN]
unset($MCONF);        

include ("conf.php");
include ($BACK_PATH."init.php");
include ($BACK_PATH."template.php");
include ("locallang.php");

if (!defined('PATH_tslib')) {
    if (@is_dir(PATH_site.'typo3/sysext/cms/tslib/')) {
        define('PATH_tslib', PATH_site.'typo3/sysext/cms/tslib/');
    } elseif (@is_dir(PATH_site.'tslib/')) {
        define('PATH_tslib', PATH_site.'tslib/');
    }
}

include_once(PATH_t3lib."class.t3lib_scbase.php");
include_once(PATH_t3lib."class.t3lib_div.php");
include_once(PATH_t3lib."class.t3lib_page.php");
include_once(PATH_t3lib."class.t3lib_tstemplate.php");
include_once(PATH_t3lib."class.t3lib_tsparser_ext.php");
include_once(PATH_tslib.'class.tslib_fe.php');



        // ....(But no access check here...)
        // DEFAULT initialization of a module [END] 

class tx_publish2static_module1 extends t3lib_SCbase {
        
        /**
         * Main function of the module. Write the content to $this->content
         */
        function main()        {
                global $AB,$BE_USER,$LANG,$BACK_PATH,$TCA_DESCR,$TCA,$HTTP_GET_VARS,$HTTP_POST_VARS,$CLIENT,$TYPO3_CONF_VARS;
                
                        // Draw the header.
                $this->doc = t3lib_div::makeInstance("mediumDoc");
                $this->doc->backPath = $BACK_PATH;
                

                $this->pageinfo = t3lib_BEfunc::readPageAccess($this->id,$this->perms_clause);
                $access = is_array($this->pageinfo) ? 1 : 0;
                if (($this->id && $access) || ($BE_USER->user["admin"] && !$this->id))        {
                        if ($BE_USER->user["admin"] && !$this->id)        {
                                $this->pageinfo=array("title" => "[root-level]","uid"=>0,"pid"=>0);
                        }

                        //$headerSection = $this->doc->getHeader("pages",$this->pageinfo,$this->pageinfo["_thePath"])."<br>".$LANG->php3Lang["labels"]["path"].": ".t3lib_div::fixed_lgd_pre($this->pageinfo["_thePath"],50);

                        $this->content.=$this->doc->startPage($LANG->getLL("process"));
                        $this->content.=$this->doc->header($LANG->getLL("process"));
                        $this->content.=$this->doc->spacer(5);
                        //$this->content.=$this->doc->section("",$this->doc->funcMenu($headerSection,t3lib_BEfunc::getFuncMenu($this->id,"SET[function]",$this->MOD_SETTINGS["function"],$this->MOD_MENU["function"])));
                        $this->content.=$this->doc->divider(5);

                                
                        // Render content:
                        //$this->moduleContent();

                        
                }                                
                $this->content.=$this->doc->spacer(10);
        }
        function printContent()        {
                global $SOBE;

                $this->content.=$this->doc->middle();
                $this->content.=$this->doc->endPage();
                echo $this->content;
                $this->moduleContent();
        }
        
        function getFileName($id) {
            $pageSelect = new t3lib_pageSelect();
            $page = $pageSelect->getPage($id);
            $template = t3lib_div::makeInstance("t3lib_tsparser_ext");
            $template->tt_track=0;
            $template->init();
            $sys_page = t3lib_div::makeInstance("t3lib_pageSelect");
            $rootLine = $sys_page->getRootLine($id);
            $template->runThroughTemplates($rootLine,$template_uid);
            $template->generateConfig();
            $tmp_tslib_fe = t3lib_div::makeInstanceClassName('tslib_fe');
//            $tsfe = new $tmp_tslib_fe($TYPO3_CONF_VARS,$id,0);
            $tsfe = new $tmp_tslib_fe($GLOBALS["TYPO3_CONF_VARS"],$id,0);
            $tsfe->config['config'] = $template->setup['config.'];
            $tsfe->sys_page = $sys_page;
            $GLOBALS["TSFE"] = $tsfe;
            $linkData = $template->linkData($page,'','','index.php');
            $url = $linkData['totalURL'];
            //echo $url;
            //print_r($linkData);
            return $url;
        }
        function wgetFile($path,$filename) {
            global $LANG;
            $publishConfig = unserialize($GLOBALS["TYPO3_CONF_VARS"]["EXT"]["extConf"]["publish2static"]);
            $t3url=$publishConfig["t3url"];
            if($publishConfig["wgetUser"]) {
                $account=" --http-user=".$publishConfig["wgetUser"]." --http-passwd=".$publishConfig["wgetPassword"];
            } else {
                $account="";
            }        
            $args=$account." --proxy=".$publishConfig["wgetProxy"]." -Pstatic -nH --cut-dirs=1 -nc -x -p -E -np -t10 -A*.* ";
            $args.=$publishConfig["t3url"]."/".$filename." ";
            $ex=$publishConfig["wgetPath"]." ".$args;
            if($publishConfig["verbose"]) {
                echo "<br>".$LANG->getLL("downloadFile")." <b>".$filename."</b><br>";
                echo $ex."<br>";
                echo "<font color=blue>";
                $output=system($ex."2>&1 | sed 's/$/<br>/g'");
                echo "</font>";
                echo "<br>";
            } else {
                exec($ex);
                echo ".";
            }
            $file=$path."/".$filename;
            $return=0;
            if(is_file($file)) {
                if($publishConfig["verbose"]) {
                    echo "<b><font color=green>OK</font></b><br>";
                }
                $return=1;
            } else {
                if($publishConfig["verbose"]) {
                    echo "<b><font color=red> ".$LANG->getLL("failed")."</font></b><br>";
                }
            }
            flush();
            return $return;
        }

        function wgetPage($path,$id) {
            $filename = $this->getFileName($id);
            return $this->wgetFile($path, $filename);
        }

        function correctZoomPicFile($path,$file,$wget=1) {
            $fd=fopen($file,"r");
            $html=fread($fd,filesize($file));
            fclose($fd);
            while(($sp=strpos($html,"onclick=\"openPic('showpic.php?file="))!=false) {
                $ep=strpos($html,"file=",$sp)+5; 
                $html=substr_replace($html,"onclick=\"openPic(",$sp,$ep-$sp);  
                $sp=strpos($html,"onclick=\"openPic(",$sp);
                $sp=strpos($html,chr(40),$sp);
                $ep=strpos($html,"&amp;",$sp+=1); 
                $url=substr($html,$sp,$ep-$sp);
                $url=rawurldecode($url);
                if($publishConfig["verbose"]) {
                    echo "<br>".$LANG->getLL("correctedOnClick")." <b>".$url."</b>";
                }
                $html=substr_replace($html,"'".$url."'",$sp,$ep-$sp);  
                $sp=strpos($html,"&amp;",$sp+=1); 
                $ep=strpos($html,",",$sp); 
                $html=substr_replace($html,"",$sp,$ep-$sp);  
                if($wget) {
                    $this->wgetFile($path,$url);
                }
            }
            $fd=fopen($file,"w");
            if(!fwrite($fd,$html)) {
                echo "<b><font color=red> ".$LANG->getLL("failed")."</font></b><br>";
            }
            fclose($fd);
        }
        function correctZoomPic($path,$id,$shortcut=0) {
            global $LANG;
            $publishConfig = unserialize($GLOBALS["TYPO3_CONF_VARS"]["EXT"]["extConf"]["publish2static"]);
            $filename=$this->getFileName($id);
            if(!strpos($filename,".html")) {
                $filename.=".html";
            }
            $file=$path."/".$filename;
            $qs="select * from tt_content where pid=".$id." and CType='image' and image_zoom=1";
            $content=mysql(TYPO3_db,$qs);
            if(mysql_num_rows($content)!=0) {
                if($shortcut==0) {
                    if($publishConfig["verbose"]) {
                        echo "<br>".$LANG->getLL("correctedZoomPic")." <b>".$filename."</b><br>";
                    }
                    while($content_row = mysql_fetch_assoc($content)) { 
                        $this->correctZoomPicFile($path,$file);
                    }
                } else {
                    $qs="select * from pages where shortcut=".$id;
                    $pages=mysql(TYPO3_db,$qs);
                    if(mysql_num_rows($pages)!=0) {
                        while($page_row = mysql_fetch_assoc($pages)) { 
                            $shortcutId=$page_row["uid"];
                            $shortcutFilename=$this->getFileName($shortcutId);
                            if(!strpos($shortcutFilename,".html")) {
                                $shortcutFilename.=".html";
                            }
                            $file=$path."/".$shortcutFilename;
                            if($publishConfig["verbose"]) {
                                echo "<br>".$LANG->getLL("correctedZoomPicShortcut")." <b>".$shortcutFilename."(".$filename.")</b><br>";
                            }
                            $this->correctZoomPicFile($path,$file,0);
                        }
                    }
                }
            }
        }
        function correctMailFormPlus($path,$id) {
            global $LANG;
            $publishConfig = unserialize($GLOBALS["TYPO3_CONF_VARS"]["EXT"]["extConf"]["publish2static"]);
            $filename=$this->getFileName($id);
            if(!strpos($filename,".html")) {
                $filename.=".html";
            }
            $file=$path."/".$filename;
            $qs="select * from tt_content where pid=".$id." and  list_type='th_mailformplus_pi1'";
            $content=mysql(TYPO3_db,$qs);
            if(mysql_num_rows($content)!=0) {
                while($content_row = mysql_fetch_assoc($content)) { 
                    if($publishConfig["verbose"]) {
                        echo "<br>".$LANG->getLL("correctedMailFormPlus")." <b>".$filename."</b><br>";
                    }
                    $fd=fopen($file,"r");
                    $html=fread($fd,filesize($file));
                    fclose($fd);
                    $sp=strpos($html,"<form action=\"");
                    $ep=strpos($html,chr(34),$sp+=14); 

                    $sp=strpos($html,"onsubmit=\"",$ep);
                    $ep=strpos($html,chr(34),$sp+10); 
                    $jsFuncName=substr($html,$sp+=9,$ep-$sp+1);  
                    $html=substr_replace($html,"return publish2staticFromMailFormPlus(this);",$sp+1,$ep-$sp-1);  
                    if($publishConfig["verbose"]) {
                        echo $LANG->getLL("correctedOnSubmit")." <b>\"return publish2staticFromMailFormPlus(this)\"</b><br>";
                    }
                    $sp=strpos($jsFuncName,"return",0);
                    if($sp==FALSE) {
                        $sp=0;
                        $ep=strpos($jsFuncName,chr(41),$sp); 
                    } else {
                        $ep=strpos($jsFuncName,chr(41),$sp+=7); 
                    }
                    if($publishConfig["verbose"]) {
                        echo $LANG->getLL("insertScript")." <b>\"publish2staticFromMailformPlus\"</b><br>";
                    }
                    $jsFuncName=substr($jsFuncName,$sp,$ep-$sp+1);
                    $sp=strpos($html,"</head>");
                    $newHtml=substr($html,0,$sp);
                    $newHtml.="<!-- inserted from public2static TYPO3 extension -->\n";
                    $newHtml.="<script type=\"text/javascript\">\n";
                    $newHtml.="<!--\n";
                    $newHtml.="function publish2staticFromMailFormPlus(input) {\n";
                    $newHtml.="  if(!".$jsFuncName.") {\n";
                    $newHtml.="    return false;\n";
                    $newHtml.="  }\n";
                    $newHtml.="  var mailto=\"mailto:\";\n";
                    $newHtml.="  mailto+=input.elements.EMAIL_TO.value;\n";
                    $newHtml.="  mailto+=\"?\";\n";
                    $newHtml.="  if(input.elements.recipient.value) {\n";
                    $newHtml.="    mailto+=\"bcc=\";\n";
                    $newHtml.="    mailto+=input.elements.recipient.value;\n";
                    $newHtml.="    mailto+=\"&\";\n";
                    $newHtml.="  }\n";
                    $newHtml.="  if(input.elements.EMAIL_SUBJ.value) {\n";
                    $newHtml.="    mailto+=\"subject=\";\n";
                    $newHtml.="    mailto+=input.elements.EMAIL_SUBJ.value;\n";
                    $newHtml.="    mailto+=\"&\";\n";
                    $newHtml.="  }\n";
                    $newHtml.="  mailto+=\"body=\";\n";
                    $newHtml.="  var i=0;\n";
                    $newHtml.="  while(input.elements[i].name) {\n";
                    $newHtml.="    if(input.elements[i].name==\"reset\" || input.elements[i].name==\"formtype_mail\") {\n";
                    $newHtml.="    i++;\n";
                    $newHtml.="    break;\n";
                    $newHtml.="    }\n";
                    $newHtml.="    if(input.elements[i].name==\"subject\" || input.elements[i].name==\"html_enabled\" || input.elements[i].name==\"recipient\" || input.elements[i].name==\"locationData\"\n";
                    $newHtml.="    ||input.elements[i].name==\"EMAIL_REDIRECT\" || input.elements[i].name==\"EMAIL_REQUIREDFIELDS\" || input.elements[i].name==\"id\"\n";
                    $newHtml.="    ||input.elements[i].name==\"EMAIL_TO\" || input.elements[i].name==\"EMAIL_SUBJ\" || input.elements[i].name==\"EMAIL_SENDER\") {\n";
                    $newHtml.="    i++;\n";
                    $newHtml.="    continue;\n";
                    $newHtml.="    }\n";
                    $newHtml.="    if(input.elements[i].type==\"checkbox\" || input.elements[i].type==\"radio\") {\n";
                    $newHtml.="      if(!input.elements[i].checked) {\n";
                    $newHtml.="        i++;\n";
                    $newHtml.="        continue;\n";
                    $newHtml.="      }\n";
                    $newHtml.="    }\n";
                    $newHtml.="    if(input.elements[i].value) {\n";
                    $newHtml.="      mailto+=input.elements[i].name;\n";
                    $newHtml.="      mailto+=\"=\";\n";
                    $newHtml.="      mailto+=input.elements[i].value;\n";
                    $newHtml.="      mailto+=\"%0D%0A\";\n";
                    $newHtml.="    }\n";
                    $newHtml.="    i++;\n";
                    $newHtml.="  }\n";
                    $newHtml.="  input.action=mailto;\n";
                    $newHtml.="  input.method=\"post\";\n";
                    $newHtml.="  return true;\n";
                    $newHtml.="}\n";
                    $newHtml.="// -->\n </script>\n";
                    $newHtml.=substr($html,$sp,strlen($html));

                    $fd=fopen($file,"w");
                    if(!fwrite($fd,$newHtml)) {
                        echo "<b><font color=red> ".$LANG->getLL("failed")."</font></b><br>";
                    }
                    fclose($fd);
                }
            }
        }
        function correctMailForm($path,$id) {
            global $LANG;
            $publishConfig = unserialize($GLOBALS["TYPO3_CONF_VARS"]["EXT"]["extConf"]["publish2static"]);
            $filename=$this->getFileName($id);
            if(!strpos($filename,".html")) {
                $filename.=".html";
            }
            $file=$path."/".$filename;
            $qs="select * from tt_content where pid=".$id." and CType='mailform'";
            $content=mysql(TYPO3_db,$qs);
            if(mysql_num_rows($content)!=0) {
                while($content_row = mysql_fetch_assoc($content)) { 
                    if($publishConfig["verbose"]) {
                        echo "<br>".$LANG->getLL("correctedMailForm")." <b>".$filename."</b><br>";
                    }
                    $fd=fopen($file,"r");
                    $html=fread($fd,filesize($file));
                    fclose($fd);
                    $recipient=$content_row["subheader"];
                    $sp=strpos($html,"<form action=\"");
                    $ep=strpos($html,chr(34),$sp+=14); 

                    $sp=strpos($html,"onsubmit=\"",$ep);
                    $ep=strpos($html,chr(34),$sp+10); 
                    $jsFuncName=substr($html,$sp+=9,$ep-$sp+1);  
                    $html=substr_replace($html,"return publish2staticFromMailForm(this);",$sp+1,$ep-$sp-1);  
                    if($publishConfig["verbose"]) {
                        echo $LANG->getLL("correctedOnSubmit")." <b>\"return publish2staticFromMailForm(this)\"</b><br>";
                    }
                    $sp=strpos($jsFuncName,"return",0);
                    if($sp==FALSE) {
                        $sp=0;
                        $ep=strpos($jsFuncName,chr(41),$sp); 
                    } else {
                        $ep=strpos($jsFuncName,chr(41),$sp+=7); 
                    }
                    if($publishConfig["verbose"]) {
                        echo $LANG->getLL("insertScript")." <b>\"publish2staticFromMailForm\"</b><br>";
                    }
                    $jsFuncName=substr($jsFuncName,$sp,$ep-$sp+1);
                    $sp=strpos($html,"</head>");
                    $newHtml=substr($html,0,$sp);
                    $newHtml.="<!-- inserted from public2static TYPO3 extension -->\n";
                    $newHtml.="<script type=\"text/javascript\">\n";
                    $newHtml.="<!--\n";
                    $newHtml.="function publish2staticFromMailForm(input) {\n";
                    $newHtml.="  var mailto=\"mailto:".$recipient."?\";\n";
                    $newHtml.="  if(input.elements.subject.value) {\n";
                    $newHtml.="    mailto+=\"subject=\";\n";
                    $newHtml.="    mailto+=input.elements.subject.value;\n";
                    $newHtml.="    mailto+=\"&\";\n";
                    $newHtml.="  }\n";
                    $newHtml.="  mailto+=\"body=\";\n";
                    $newHtml.="  var i=0;\n";
                    $newHtml.="  while(input.elements[i].name) {\n";
                    $newHtml.="    if(input.elements[i].name==\"reset\" || input.elements[i].name==\"formtype_mail\") {\n";
                    $newHtml.="    break;\n";
                    $newHtml.="    }\n";
                    $newHtml.="    if(input.elements[i].name==\"subject\" || input.elements[i].name==\"html_enabled\" || input.elements[i].name==\"recipient\" || input.elements[i].name==\"locationData\") {\n";
                    $newHtml.="    i++;\n";
                    $newHtml.="    continue;\n";
                    $newHtml.="    }\n";
                    $newHtml.="    if(input.elements[i].type==\"checkbox\" || input.elements[i].type==\"radio\") {\n";
                    $newHtml.="      if(!input.elements[i].checked) {\n";
                    $newHtml.="        i++;\n";
                    $newHtml.="        continue;\n";
                    $newHtml.="      }\n";
                    $newHtml.="    }\n";
                    $newHtml.="    if(input.elements[i].value) {\n";
                    $newHtml.="      mailto+=input.elements[i].name;\n";
                    $newHtml.="      mailto+=\"=\";\n";
                    $newHtml.="      mailto+=input.elements[i].value;\n";
                    $newHtml.="      mailto+=\"%0D%0A\";\n";
                    $newHtml.="    }\n";
                    $newHtml.="    i++;\n";
                    $newHtml.="  }\n";
                    $newHtml.="  input.action=mailto;\n";
                    $newHtml.="  input.method=\"post\";\n";
                    $newHtml.="  return true;\n";
                    $newHtml.="}\n";
                    $newHtml.="// -->\n </script>\n";
                    $newHtml.=substr($html,$sp,strlen($html));

                    $fd=fopen($file,"w");
                    if(!fwrite($fd,$newHtml)) {
                        echo "<b><font color=red> ".$LANG->getLL("failed")."</font></b><br>";
                    }
                    fclose($fd);
                }
            }
        }
        function removeDir($dir) {
            global $LANG;
            if(!file_exists($dir)) {
                echo $LANG->getLL("nothingToCleanUp");
                return;
            }
            $publishConfig = unserialize($GLOBALS["TYPO3_CONF_VARS"]["EXT"]["extConf"]["publish2static"]);
            $d=opendir($dir);
            while($file=readdir($d)) {
                if($file!="." && $file!="..") {
                    $target=$dir."/".$file;
                    if(!is_dir($target)) {
                        unlink($target);
                    } else {
                        $this->removeDir($target);
                    }
                }
            }
            closedir($d);
            if(rmdir($dir)) {
                if($publishConfig["verbose"]) {
                    echo $dir." ";
                    echo "<b><font color=green>OK</font></b><br>";
                } else {
                    echo ".";
                }
                flush();
            } else {
                echo $LANG->getLL("cleanup")." ".$dir." ";
                echo "<b><font color=red> ".$LANG->getLL("failed")."</font></b><br>";
            }
            flush();
        }

        function getChildPages($parentId) {
            $query = "select uid,title from pages where pid=".$parentId.
                    " and deleted=0 and hidden=0";
            $pages = mysql(TYPO3_db, $query);
            $result = array();
            if (mysql_num_rows($pages) != 0) {
                while ($page = mysql_fetch_assoc($pages)) {
                    $pageId = $page["uid"];
                    $result[$pageId] = $page["title"];
                    $result += $this->getChildPages($pageId);
                }
            }
            return $result;
        }

        function moduleContent() {
            global $LANG,$TYPO3_CONF_VARS;
            $publishConfig = unserialize($GLOBALS["TYPO3_CONF_VARS"]["EXT"]["extConf"]["publish2static"]);
            $id=t3lib_div::GPvar("id");
            $sep=t3lib_div::GPvar("sep");
            $domain=t3lib_div::GPvar("domain");
            $cleanup=t3lib_div::GPvar("cleanup");
            $forms=array();
            
            // Cache Lschen
            $res = mysql(TYPO3_db,"DELETE FROM cache_pages");
            $res = mysql(TYPO3_db,"DELETE FROM cache_pagesection");

            $verz=$domain;
            $rootPath="../../../../fileadmin/".$verz;
            $path=$rootPath."/static/";

            ob_start();
            if($cleanup=="" || $cleanup==1) {
                echo $LANG->getLL("cleanup")." 'static' link ";
                if(!file_exists("static")) {
                    echo "<b><font color=green>OK</font></b><br>";
                } else {
                    if(unlink("static")) { 
                        echo "<b><font color=green>OK</font></b><br>";
                    } else {
                        echo "<b><font color=red> ".$LANG->getLL("failed")."</font></b>";
                    }
                }
                echo $LANG->getLL("cleanup").": ";
                $this->removeDir($path);
                echo "<b><font color=green>OK</font></b><br><br>";

                flush();
                ob_end_flush();
                ob_start();
            }

            if($cleanup=="") {
                if(!file_exists($rootPath)) {
                    mkdir($rootPath,0755);
                }
                if(!file_exists($path)) {
                    mkdir($path,0755);
                }
                echo $LANG->getLL("createSymLink")." 'static' ";
                if(symlink($path,"static")) {
                    echo "<b><font color=green>OK</font></b><BR><BR>";
                } else {
                    echo "<b><font color=red> ".$LANG->getLL("failed")."</font></b>";
                }
                echo $LANG->getLL("publishing")."<br>";

                flush();

                $pages = array($id => "Root");
                $pages += $this->getChildPages($id);
                foreach ($pages as $uid => $title) {
                    if ($this->wgetPage($path, $uid)) {
                        $this->correctMailForm($path, $uid);
                        $this->correctMailFormPlus($path, $uid);
                        $this->correctZoomPic($path, $uid);
                    }
                }                                

                /* after all pages downloaded correct shortcut files */
                foreach ($pages as $uid => $title) {
                    $this->correctZoomPic($path, $uid, 1);
                }
                if (!$publishConfig["verbose"]) {
                    echo "<b><font color=green>OK</font></b>";
                }

                echo "<br><br>".$LANG->getLL("copyTypo3TempAndMedia");
                if($publishConfig["verbose"]) {
                    echo "<br>";
                }
                if(!file_exists($path."uploads/")) {
                    mkdir($path."uploads/",0755);
                }
                if(!file_exists($path."uploads/media/")) {
                    mkdir($path."uploads/media/",0755);
                }
                $copied=array();
                $filesInDir = t3lib_div::getFilesInDir($path,"html",0,1);
                while(list(,$file)=each($filesInDir))        {
                    $file=$path.$file;
                    $fd=fopen($file,"r");
                    $htm = fread ($fd, filesize ($file));
                    fclose($fd);
                    do {
                        $p=strpos($htm,"typo3temp/",$p);
                        if($p) {
                            $p+=10;
                            $e=strpos($htm,chr(34),$p);
                            $fgif=substr($htm,$p,$e-$p);
                            if (!in_array($fgif, $copied)) {
                                if (!file_exists($path."typo3temp/".$fgif)) {
                                    if($publishConfig["verbose"]) {
                                        echo "&nbsp;".$LANG->getLL("copyResource")."typo3temp/".$fgif;
                                    } else {
                                        echo ".";
                                    }
                                    if (!copy($BACK_PATH."../../../../typo3temp/".$fgif,$path."typo3temp/".$fgif)) {
                                        echo "<b><font color=red> ".$LANG->getLL("failed")."</font></b><br>";
                                    } else {
                                        if($publishConfig["verbose"]) {
                                            echo "<b><font color=green> OK</font></b><br>";
                                        }
                                        $copied[]=$fgif;
                                    }
                                    flush();
                                }
                            }
                        }
                    }
                    while ($p);
                    $p=0;
                    do {
                        $p=strpos($htm,"media/",$p);
                        if($p) {
                            $p+=6;
                            $e=strpos($htm,chr(34),$p);
                            $fgif=substr($htm,$p,$e-$p);
                            if (!in_array($fgif, $copied)) {
                                if(substr($htm,$p-14,8)=="uploads/") { // "uploads/media/"
                                    if (!file_exists($path."uploads/media/".$fgif)) {
                                        if(strpos($fgif,".htm")) {
                                            $this->wgetFile($path,"uploads/media/".$fgif);
                                                $copied[]=$fgif;
                                        } else {
                                            if($publishConfig["verbose"]) {
                                                echo "&nbsp;".$LANG->getLL("copyResource")."uploads/media/".$fgif;
                                            } else {
                                                echo ".";
                                            }
                                            if (!copy($BACK_PATH."../../../../uploads/media/".$fgif,$path."uploads/media/".$fgif)) {
                                                echo "<b><font color=red> ".$LANG->getLL("failed")."</font></b><br>";
                                            } else {
                                                if($publishConfig["verbose"]) {
                                                        echo "<b><font color=green> OK</font></b><br>";
                                                }
                                                $copied[]=$fgif;
                                            }
                                        }
                                        flush();
                                    }
                                } else {                                // "media/"
                                    if (!file_exists($path."media/".$fgif)) {
                                        if($publishConfig["verbose"]) {
                                            echo "&nbsp;".$LANG->getLL("copyResource")."media/".$fgif;
                                        } else {
                                            echo ".";
                                        }
                                        if (!copy($BACK_PATH."../../../../media/".$fgif,$path."media/".$fgif)) {
                                            echo "<b><font color=red> ".$LANG->getLL("failed")."</font></b><br>";
                                        } else {
                                            if($publishConfig["verbose"]) {
                                                    echo "<b><font color=green> OK</font></b><br>";
                                            }
                                            $copied[]=$fgif;
                                        }
                                        flush();
                                    }
                                }
                            }
                        }
                    }
                    while ($p);
                    $e=strpos($htm,"<head>");
                    $htm=substr($htm,0,$e+6)."\n<!--\n     This site was extracted from TYPO3 with the publish2static extension\n     See at www.bj-ig.de\n-->\n\n".substr($htm,$e+6,strlen($htm));
                    $sm=strpos($htm,"<meta");
                    $em=strpos($htm,">",$sm);
                    $htm=substr($htm,0,$sm)."\n<meta name=\"publish2static\" content=\"Extension to Publish Content from CMS Typo3; www.bj-ig.de\" />\n".substr($htm,$sm,strlen($htm));
                    //die(substr($htm,$sm,$em-$sm+1));

                    $fd=fopen($file,"w");
                    $htm = fwrite ($fd,$htm);
                    fclose($fd);        
                }
                if(!$publishConfig["verbose"]) {
                    echo "<b><font color=green> OK</font></b>";
                }
                echo "<br><br>";
                flush();
                $filename=$this->getFileName($id);
                if(!strpos($filename,".html")) {
                    $filename.=".html";
                }
                if(strcmp($filename,"index.html")) {
                    echo "copy '".$filename."' -> 'index.html' ";
                    if(copy($path."/".$filename, $path."index.html")) {
                        echo "<b><font color=green>OK</font></b><BR><BR>";
                    } else {
                        echo "<b><font color=red> ".$LANG->getLL("failed")."</font></b><br>";
                    }
                }
                echo $LANG->getLL("cleanup")." 'static' link ";
                if(unlink("static")) { 
                    echo "<b><font color=green>OK</font></b><BR><BR>";
                } else {
                    echo "<b><font color=red> ".$LANG->getLL("failed")."</font></b><br>";
                }
                echo $LANG->getLL("ready")."&nbsp;".$LANG->getLL("click")."<b><a href='".$path."' target='_blank'>".$LANG->getLL("previewafterpublish")."</b></u><BR>";
            }
            echo "<HR><br><br><br><br>&nbsp;<b><a href='index.php'>".$LANG->getLL("back")."</a><a href='index.php?function=2'>".$LANG->getLL("next")."</a></b>";                
        }
}


if (defined("TYPO3_MODE") && $TYPO3_CONF_VARS[TYPO3_MODE]["XCLASS"]["ext/publish2static/mod1/publish.php"]) {
    include_once($TYPO3_CONF_VARS[TYPO3_MODE]["XCLASS"]["ext/publish2static/mod1/publish.php"]);
}




// Make instance:
$SOBE = t3lib_div::makeInstance("tx_publish2static_module1");
$SOBE->init();


$SOBE->main();
$SOBE->printContent();

?>
