extern "C" {
#include <tcl.h>
};

#include <kaction.h>

#include "QTclInterp.h"
#include "QTclObject.h"
#include "QTclUtil.h"

#include "QTclKDEAction.h"

class QTclKDEKActionFactory : public QTclFactory {
public:
  virtual KAction *create(const QString& className,QObject *parent,const char *name ) {
   if(className=="KAction")            return new KAction(parent,name);
   if(className=="KActionMenu")        return new KActionMenu(parent,name);
   if(className=="KActionSeparator")   return new KActionSeparator(parent,name);
   if(className=="KFontAction")        return new KFontAction(parent,name);
   if(className=="KFontSizeAction")    return new KFontSizeAction(parent,name);
   if(className=="KListAction")        return new KListAction(parent,name);
   if(className=="KRadioAction")       return new KRadioAction(parent,name);
   if(className=="KRecentFilesAction") return new KRecentFilesAction(parent,name);
   if(className=="KSelectAction")      return new KSelectAction(parent,name);
   if(className=="KToggleAction")      return new KToggleAction(parent,name);
   return 0;
  }
  virtual QStringList classNames() {
    const char *clNames[]= { "KAction", "KActionMenu", "KActionSeparator", "KFontAction",
      "KFontSizeAction", "KListAction", "KRadioAction", "KRecentFilesAction",
      "KSelectAction", "KToggleAction"
    };
    return QTclCreateQStringList(QTCLARSIZE(clNames),clNames);
  }
};

int QTclKDEActionInitCmd(QTclInterp * /*qinterp*/) {
  QTclInterp::registerFactory(new QTclKDEKActionFactory);
  return TCL_OK;
}
