extern "C" {
#include <tcl.h>
};

#include <kapplication.h>
#include <kfontdialog.h>
#include <qxembed.h>

#include "QTclObject.h"
#include "QTclUtil.h"
#include "QTclInterp.h"
#include "QTclWidget.h"
#include "QTclApplication.h"

#include "QTclKDECmd.h"

static int QTclKFontDialogMethods(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
KFontDialog *w=(KFontDialog*)clientData;
  if(argc<2) {
    Tcl_AppendElement(interp,"setFont");
    Tcl_AppendElement(interp,"font");
    if(argc<1) return TCL_OK;
  } else if(argc==3 && !strcmp(argv[1],"setFont")) {
    w->setFont(QFont(argv[2]));
    return TCL_OK;
  } else if(argc==2 && !strcmp(argv[1],"font")) {
    Tcl_AppendResult(interp,QTclS2C(w->font().toString()),0);
    return TCL_OK;
  }
  return QTclDialogMethods(clientData,interp,argc,argv);
}

static int QTclKApplicationMethods(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
KApplication *w=(KApplication*)clientData;
  if(argc<2) {
    Tcl_AppendElement(interp,"topWidget");
    if(argc<1) return TCL_OK;
  } else if(argc==3 && !strcmp(argv[1],"topWidget")) {
    QWidget *t;
    if(QTclInterp::getWidgetByName(interp,argv[2],&t)!=TCL_OK) return TCL_ERROR;
    w->setTopWidget(t);
    return TCL_OK;
  }
  return QTclApplicationMethods(clientData,interp,argc,argv);
}

static int QTclKDialogBaseMethods(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
KDialogBase *w=(KDialogBase*)clientData;
  if(argc<2) {
    Tcl_AppendElement(interp,"mainWidget");
    if(argc<1) return TCL_OK;
  } else if(!strcmp(argv[1],"mainWidget")) {
    switch(argc) {
      case 2: {
        QWidget *top=w->mainWidget();
        if(top) {
          char buffer[1024];
          Tcl_AppendElement(interp,QTclInterp::objectName(top,buffer,sizeof(buffer)));
        }
      }
      return TCL_OK;
      case 3: {
        QWidget *t;
        if(QTclInterp::getWidgetByName(interp,argv[2],&t)!=TCL_OK) return TCL_ERROR;
        w->setMainWidget(t);
      }
      return TCL_OK;
      default:
        Tcl_WrongArgs(interp,2,argv,"[<widget>]");
    }
  }
  return QTclDialogMethods(clientData,interp,argc,argv);
}

static int QTclQXEmbedMethods(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
QXEmbed *w=(QXEmbed*)clientData;
  if(argc<2) {
    Tcl_AppendElement(interp,"embed <winId>");
    Tcl_AppendElement(interp,"winId");
    Tcl_AppendElement(interp,"autoDelete");
    Tcl_AppendElement(interp,"setAutoDelete <bool>");
    Tcl_AppendElement(interp,"sendDelete");
    Tcl_AppendElement(interp,"protocol");
    Tcl_AppendElement(interp,"setProtocol XPLAIN/XEMBED");
    if(argc<1) return TCL_OK;
  } else if(argc==3 && !strcmp(argv[1],"embed")) {
    int value;
    if(Tcl_GetInt(interp,argv[2],&value)!=TCL_OK) return TCL_ERROR;
    w->embed(value);
    return TCL_OK;
  } else if(argc==2 && !strcmp(argv[1],"winId")) {
    Tcl_AppendInt(interp,w->embeddedWinId());
    return TCL_OK;
  } else if(argc==2 && !strcmp(argv[1],"autoDelete")) {
    Tcl_AppendInt(interp,w->autoDelete());
    return TCL_OK;
  } else if(argc==3 && !strcmp(argv[1],"setAutoDelete")) {
    int value;
    if(!Tcl_GetBoolean(interp,argv[2],&value)!=TCL_OK) return TCL_ERROR;
    w->setAutoDelete(value);
    return TCL_OK;
  } else if(argc==2 && !strcmp(argv[1],"sendDelete")) {
    w->sendDelete();
    return TCL_OK;
  } else if(argc==2 && !strcmp(argv[1],"protocol")) {
    QXEmbed::Protocol p=w->protocol();
    if(p==QXEmbed::XEMBED) {
       Tcl_AppendResult(interp,"XEMBED",0);
    } else if(p==QXEmbed::XPLAIN) {
       Tcl_AppendResult(interp,"XPLAIN",0);
    } else {
       Tcl_AppendInt(interp,p);
    }
    return TCL_OK;
  } else if(argc==3 && !strcmp(argv[1],"setProtocol")) {
    QXEmbed::Protocol p;
    int v;
    if(!strcmp(argv[2],"XEMBED")) {
      p=QXEmbed::XEMBED;
    } else if(!strcmp(argv[2],"XPLAIN")) {
      p=QXEmbed::XPLAIN;
    } else if(Tcl_GetInt(interp,argv[2],&v)==TCL_OK) {
      p=(QXEmbed::Protocol)v;
    } else {
      return TCL_ERROR;
    }
    w->setProtocol(p);
    return TCL_OK;
  }
  return QTclWidgetMethods(clientData,interp,argc,argv);
}

int QTclKDECmdInitCmd(QTclInterp * /*qinterp*/) {
  QTclInterp::registerMethods("KApplication",&QTclKApplicationMethods);
  QTclInterp::registerMethods("KFontDialog",&QTclKFontDialogMethods);
  QTclInterp::registerMethods("KDialogBase",&QTclKDialogBaseMethods);
  QTclInterp::registerMethods("QXEmbed",&QTclQXEmbedMethods);
  return TCL_OK;
}

