extern "C" {
#include <tcl.h>
#include <assert.h>
};

#include <kaction.h>
#include <qstring.h>
#include <qcstring.h>
#include <dcopclient.h>
#include <dcopref.h>
#include <dcopobject.h>

#include <kapplication.h>

#include "QTclInterp.h"
#include "QTclObject.h"
#include "QTclUtil.h"


#include "QTclKDEDcop.h"

static int QTcl_ScanSignature(Tcl_Interp *interp,QCString signature,QStringList *l) {
int spos=signature.find('(',0);
const char *x=signature;
bool searchEnd=(spos>=0);
  if(searchEnd) {
    spos++;
  } else {
    spos=0;
  }
  int epos;
  while((epos=signature.find(',',spos))>=0) {
    l->append(signature.mid(spos,epos-spos));
    spos=epos+1;
  }
  if(searchEnd) {
    epos=signature.find(')',spos);
    if(epos<0) {
      Tcl_AppendResult(interp,"dcop: missing ')' in signature:",(const char*)signature,0);
      return TCL_ERROR;
    }
  } else {
    epos=signature.length();
  }
  if(epos-spos) l->append(signature.mid(spos,epos-spos));
  x=signature;
  return TCL_OK;
}

static int QTcl_AppendArguments(Tcl_Interp *interp,QCString signature,QByteArray arguments) {
QStringList sigs;
  if(QTcl_ScanSignature(interp,signature,&sigs)!=TCL_OK) return TCL_ERROR;
  QDataStream s(arguments,IO_ReadOnly);
  for (QStringList::ConstIterator it=sigs.begin();it!=sigs.end();++it) {
    if((*it)=="int") {
      int r;
      s>>r;
      Tcl_AppendInt(interp,r);
    } else if((*it)=="bool") {
      bool r;
      s>>r;
      Tcl_AppendBool(interp,r);
    } else if((*it)=="QString") {
      QString r;
      s>>r;
      Tcl_AppendElement(interp,QTclS2C(r));
    } else if((*it)=="QCStringList") {
      QCStringList r;
      s>>r;
      Tcl_AppendQCStringList(interp,r);
    } else if((*it)=="DCOPRef") {
      DCOPRef r;
      s>>r;
      Tcl_AppendElement(interp,(const char*)(r.obj()));
    } else if((*it)=="void") {
    } else {
      Tcl_AppendResult(interp,"dcop:invalid sub-signature:",(*it).ascii(),0);
      return TCL_ERROR;
    }
  }
  return TCL_OK;
}

static int QTcl_AppendQDataStream(Tcl_Interp *interp,QDataStream& s,const char *value,QString signature) {
  if(signature=="void") {
    return TCL_OK;
  } else if (signature=="QString") {
    s << QString(value);
    return TCL_OK;
  } else if(signature=="bool") {
    int v;
    if(Tcl_GetBoolean(interp,value,&v)!=TCL_OK) return TCL_ERROR;
    s << (v?true:false);
    return TCL_OK;
  } else if(signature=="QStringList") {
    QStringList v;
    if(Tcl_GetQStringList(interp,value,v)!=TCL_OK) return TCL_ERROR;
    s << v;
    return TCL_OK;
  } else if(signature=="int") {
    int v;
    if(Tcl_GetInt(interp,value,&v)!=TCL_OK) return TCL_ERROR;
    s << v;
    return TCL_OK;
  } 
  Tcl_AppendResult(interp,"dcop:signature not implemented:",signature.ascii(),0);
  return TCL_ERROR;
}

class QTclKDEDcopObjectProxy: public DCOPObjectProxy {
public:
  QTclKDEDcopObjectProxy(Tcl_Interp *interp,DCOPClient *client):DCOPObjectProxy(client),_interp(interp) {}
  virtual bool process(const QCString &object,const QCString &function,const QByteArray &arguments,QCString &returnType,QByteArray &returnValue) {
    Tcl_AppendElement(_interp,(const char *)object); // procname
    Tcl_AppendElement(_interp,returnType.isNull()?"void":(const char *)returnType);
    Tcl_AppendElement(_interp,(const char *)function);
    if(QTcl_AppendArguments(_interp,function,arguments)!=TCL_OK) {
      Tcl_BackgroundError(_interp);
      return false;
    }
    QCString command(Tcl_GetStringResult(_interp));
    Tcl_ResetResult(_interp);
    int result=true;
    switch(Tcl_GlobalEval(_interp,(const char *)command)) {
      case TCL_ERROR:
        Tcl_BackgroundError(_interp);
        return false;
      case TCL_OK:
      case TCL_BREAK:
        result=true;
        break;
      case TCL_CONTINUE:
        result=false;
        break;
    }
    if(!returnType.isNull()) {
      QStringList sigs;
      if(QTcl_ScanSignature(_interp,returnType,&sigs)!=TCL_OK || sigs.size()!=1) {
        Tcl_BackgroundError(_interp);
        return false;
      }
      QDataStream s(returnValue,IO_WriteOnly);
      if(QTcl_AppendQDataStream(_interp,s,Tcl_GetStringResult(_interp),sigs.first())!=TCL_OK) {
        Tcl_BackgroundError(_interp);
        return false;
      }
    }
    return result;
  }
private:
  Tcl_Interp *_interp;
};


static int getDcopClientPtr(Tcl_Interp* interp,DCOPClient **result) {
static DCOPClient *client=0;
  if(!client) {
    client=kapp->dcopClient();
    assert(client);
    client->registerAs("ktcl");
    client->setNotifications(true);
    new QTclKDEDcopObjectProxy(interp,client);
  }
  *result=client;
  return TCL_OK;
}

static int QDcopCmd(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
//QTclInterp *qinterp=(QTclInterp*)clientData;
DCOPClient *client;
  if(getDcopClientPtr(interp,&client)!=TCL_OK) {
    return TCL_ERROR;
  }
  switch(argc) {
    case 0:
    case 1:
      Tcl_AppendElement(interp,"applications");
      Tcl_AppendElement(interp,"appId");
      Tcl_AppendElement(interp,"client");
      Tcl_AppendElement(interp,"acceptCalls");
      Tcl_AppendElement(interp,"registerAs <id> [<bool>]");
      Tcl_AppendElement(interp,"setAcceptCalls <bool>");
      Tcl_AppendElement(interp,"setNotifications <bool>");
      Tcl_AppendElement(interp,"<application> objects");
      Tcl_AppendElement(interp,"<application> <object> functions");
      Tcl_AppendElement(interp,"<application> <object> interfaces");
      Tcl_AppendElement(interp,"<application> <object> <function> [<arguments>]");
      return TCL_ERROR;
    case 2:
      if(!strcmp(argv[1],"client")) {
        QTclInterp::appendName(interp,client);
        return TCL_OK;
      }
      if(!strcmp(argv[1],"applications")) {
        Tcl_AppendQCStringList(interp,client->registeredApplications());
        return TCL_OK;
      }
      if(!strcmp(argv[1],"appId")) {
        Tcl_AppendResult(interp,(const char*)(client->appId()),0);
        return TCL_OK;
      }
      if(!strcmp(argv[1],"acceptCalls")) {
        Tcl_AppendBool(interp,client->acceptCalls());
        return TCL_OK;
      }
      break;
    case 3:
      if(!strcmp(argv[1],"registerAs")) {
        client->registerAs(argv[2]);
        return TCL_OK;
      }
      if(!strcmp(argv[1],"setAcceptCalls")) {
        int value;
        if(Tcl_GetBoolean(interp,argv[2],&value)!=TCL_OK) return TCL_ERROR;
        client->setAcceptCalls(value);
        return TCL_OK;
      }
      if(!strcmp(argv[1],"setNotifications")) {
        int value;
        if(Tcl_GetBoolean(interp,argv[2],&value)!=TCL_OK) return TCL_ERROR;
        client->setNotifications(value);
        return TCL_OK;
      }
      if(!strcmp(argv[2],"objects")) {
        Tcl_AppendQCStringList(interp,client->remoteObjects(argv[1]));
        return TCL_OK;
      }
      break;
    case 4:
      if(!strcmp(argv[3],"functions")) {
        Tcl_AppendQCStringList(interp,client->remoteFunctions(argv[1],argv[2]));
        return TCL_OK;
      } else if(!strcmp(argv[1],"registerAs")) {
        int value;
        if(!Tcl_GetBoolean(interp,argv[3],&value)==TCL_OK) return TCL_ERROR;
        client->registerAs(argv[2],value);
        return TCL_OK;
      } else if(!strcmp(argv[3],"interfaces")) {
        Tcl_AppendQCStringList(interp,client->remoteInterfaces(argv[1],argv[2]));
        return TCL_OK;
      }
    default: {
      QByteArray arguments;
      QByteArray result;
      QCString resultType;
      QStringList sigs;
      if(QTcl_ScanSignature(interp,QCString(argv[3]),&sigs)!=TCL_OK) return TCL_ERROR;
      {
        QDataStream s(arguments,IO_WriteOnly);
        QStringList::ConstIterator it=sigs.begin();
        for(int i=4;i<argc;i++) {
          if(it==sigs.end()) {
            Tcl_AppendResult(interp,"dcop: too many arguments for signature: ",argv[3],0);
            return TCL_ERROR;
          }
          if(QTcl_AppendQDataStream(interp,s,argv[i],(*it))!=TCL_OK) return TCL_ERROR;
          ++it;
        }
        if(it!=sigs.end()) {
          Tcl_AppendResult(interp,"dcop: missing arguments for signature: ",argv[3],0);
          return TCL_ERROR;
        }
      }
      if(!client->call(argv[1],argv[2],argv[3],arguments,resultType,result)) {
        Tcl_AppendResult(interp,"dcop: error in call:",0);
        for(int i=0;i<argc;i++) {
          Tcl_AppendResult(interp," ",argv[i],0);
        } 
        Tcl_AppendResult(interp,"\narguments:'",0);
        Tcl_AppendQByteArray(interp,arguments);
        Tcl_AppendResult(interp,"'",0);
        return TCL_ERROR;
      }
      if(QTcl_AppendArguments(interp,resultType,result)!=TCL_OK) return TCL_ERROR;
      return TCL_OK;
    }
    break;
  }
  Tcl_WrongArgs(interp,1,argv,0);
  QDcopCmd(clientData,interp,1,argv);
  return TCL_ERROR;
}

int QTclKDEDcopInitCmd(QTclInterp * qinterp) {
  Tcl_CreateCommand(qinterp->interp(),"dcop",QDcopCmd,(ClientData)qinterp,0);
  return TCL_OK;
}
