extern "C" {
#include <tcl.h>
};

#include <qstringlist.h>
#include <kiconloader.h>

#include "QTclPixmap.h"
#include "QTclUtil.h"

#include "QTclKDEPixmap.h"

class QTclKDEPixmapFactory : public QTclPixmapFactory {
public:
  virtual QPixmap create(const QString& name) {
    return QPixmap(SmallIcon(name));
  }
  virtual QStringList names() {
    return KGlobal::iconLoader()->queryIcons(0);
  }
  virtual QString name(QPixmap /*pixmap*/) {
    return QString();
  }
};

int QTclKDEPixmapInitCmd(QTclInterp * /*qinterp*/) {
  QTclGlobalPixmapFactory::addPixmapFactory(new QTclKDEPixmapFactory);
  return TCL_OK;
}
