extern "C" {
#include <tcl.h>
};

#include <qwidget.h>
#include <kmainwindow.h>
#include <ksystemtray.h>
#include <kaboutapplication.h>
#include <kaboutdialog.h>
#include <kaboutkde.h>
#include <kbugreport.h>
#include <kcmodule.h>
#include <kcharselect.h>
#include <kcolorbutton.h>
#include <kcolordialog.h>
#include <kdialog.h>
#include <ktabctl.h>
#include <ktextbrowser.h>
#include <ktoolbar.h>
#include <kurllabel.h>
#include <kwizard.h>
#include <kcolorcombo.h>
#include <kcombobox.h>
#include <kiconview.h>
#include <kled.h>
#include <knuminput.h>
#include <klineedit.h>
#include <klistbox.h>
#include <klistview.h>
#include <kpassdlg.h>
#include <kdatetbl.h>
#include <kpopupmenu.h>
#include <kdockwindow.h>
#include <kdualcolorbutton.h>
#include <keditcl.h>
#include <kfontdialog.h>
#include <kselect.h>
#include <kjanuswidget.h>
#include <kmenubar.h>
#include <kprogress.h>
#include <krestrictedline.h>
#include <kauthicon.h>
#include <kruler.h>
#include <kseparator.h>
#include <kstatusbar.h>
#include <kpushbutton.h>
#include <qxembed.h>

#include "QTclUtil.h"
#include "QTclWidget.h"
#include "QTclInterp.h"

#include "QTclKDEWidget.h"

class QTclKDEWidgetFactory :public QTclFactory {
public:
  virtual QObject *create(const QString& className,QObject *parentObject,const char *name) {
    if(parentObject && !((parentObject->inherits("QWidget")))) return 0; 
    QWidget *parent=(QWidget*)parentObject; // Test for Class?
    if(className=="KSystemTray")        return new KSystemTray(parent,name);
    if(className=="KAboutApplication")  return new KAboutApplication(parent,name);
    if(className=="KAboutContainer")    return new KAboutContainer(parent,name);
    if(className=="KAboutDialog")       return new KAboutDialog(parent,name);
    if(className=="KAboutKDE")          return new KAboutKDE(parent,name);
    if(className=="KAboutWidget")       return new KAboutWidget(parent,name);
    if(className=="KBugReport")         return new KBugReport(parent,name);
    if(className=="KColorDialog")       return new KColorDialog(parent,name);
    if(className=="KDialogBase")        return new KDialogBase(parent,name);
    if(className=="KDockWindow")        return new KDockWindow(parent,name);
    if(className=="KDoubleNumInput")    return new KDoubleNumInput(parent,name);
    if(className=="KEdFind")            return new KEdFind(parent,name);
    if(className=="KEdGotoLine")        return new KEdGotoLine(parent,name);
    if(className=="KEdReplace")         return new KEdReplace(parent,name);
    if(className=="KEdit")              return new KEdit(parent,name);
    if(className=="KFontChooser")       return new KFontChooser(parent,name);
    if(className=="KFontDialog")        return new KFontDialog(parent,name);
    if(className=="KIconView")          return new KIconView(parent,name);
    if(className=="KJanusWidget")       return new KJanusWidget(parent,name);
    if(className=="KMainWindow")        return new KMainWindow(parent,name);
    if(className=="KMenuBar")           return new KMenuBar(parent,name);
    if(className=="KPopupFrame")        return new KPopupFrame(parent,name);
    if(className=="KPopupMenu")         return new KPopupMenu(parent,name);
    if(className=="KPopupTitle")        return new KPopupTitle(parent,name);
    if(className=="KRootPermsIcon")     return new KRootPermsIcon(parent,name);
    if(className=="KSelector")          return new KSelector(parent,name);
    if(className=="KSeparator")         return new KSeparator(parent,name);
    if(className=="KStatusBar")         return new KStatusBar(parent,name);
    if(className=="KTabCtl")            return new KTabCtl(parent,name);
    if(className=="KToolBar")           return new KToolBar(parent,name);
    if(className=="KValueSelector")     return new KValueSelector(parent,name);
    if(className=="KWizard")            return new KWizard(parent,name);
    if(className=="KXYSelector")        return new KXYSelector(parent,name);
    if(className=="QXEmbed")          return new QXEmbed(parent,name);
    return 0;
  }
  virtual QStringList classNames() {
    const char *clNames[]={ "KAboutApplication", "KAboutContainer", "KAboutDialog", "KAboutKDE",
      "KAboutWidget", "KBugReport", "KColorDialog", "KDialogBase", "KDockWindow",
      "KDoubleNumInput", "KEdFind", "KEdGotoLine", "KEdReplace", "KEdit", "KFontChooser",
      "KFontDialog", "KIconView", "KJanusWidget", "KMainWindow", "KMenuBar", "KPopupFrame",
      "KPopupMenu", "KPopupTitle", "KRootPermsIcon", "KSelector", "KSeparator", "KStatusBar",
      "KSystemTray", "KTabCtl", "KToolBar", "KValueSelector", "KWizard", "KXYSelector"
    };
    return QTclCreateQStringList(QTCLARSIZE(clNames),clNames);
  }
};

int QTclKDEWidgetInit(QTclInterp * /*interp*/) {
  QTclInterp::registerFactory(new QTclKDEWidgetFactory);
  return TCL_OK;
}

