extern "C" {
#include <stdlib.h>
#include <unistd.h>
};

#include <qcstring.h>
#include <kapplication.h>
#include <klocale.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>


#include "QTclInterp.h"

#define OPTIONS "vV"

static const char *version="0.9";
static const char *progname="";
static const char *applicationName="KdeTcl";
static const char *comment="Kde 3 Bindings for Tcl";
static const char *copyright="(c) 2002-2004 Peter Brueckner / Brueckner & Jarosch Erfurt Germany";
static const char *text="Just now only for fun";
static const char *homepage="http://www.bj-ig.de";
static const char *bugemail="kdetcl@bj-ig.de";
static KAboutData::LicenseKey license=KAboutData::License_Unknown;


static int verbose=0;
static int dodebug=0;
static int interactive=0;
static int pipemode=0;

class KdeTclApplication : public KApplication {
public:
  KdeTclApplication() : KApplication() {
    _qinterp=new QTclKDEInterp(this,"interp");
    QTclKDECmdInitCmd(_qinterp);
    QTclKDEActionInitCmd(_qinterp);
    QTclKDEWidgetInit(_qinterp);
    QTclKDEPixmapInitCmd(_qinterp);
    QTclKDEDcopInitCmd(_qinterp);
  }
  ~KdeTclApplication() {
    delete _qinterp;
  }
  QTclInterp *qinterp() { return _qinterp; }
private:
  QTclKDEInterp *_qinterp;
};

static KCmdLineOptions options[] = {
  { "v", I18N_NOOP("verbose"), 0 },
  { "d", I18N_NOOP("debug"), 0 },
  { "V", I18N_NOOP("show version and exit"), 0 },
  { "i", I18N_NOOP("interactive mode"), 0 },
  { "p", I18N_NOOP("pipe mode"), 0 },
  { "P ", I18N_NOOP("progname"), 0 },
  { "c ", I18N_NOOP("command direct"), 0 },
  { "+[arg1]", I18N_NOOP("file to execute"), 0 },
  { 0, 0, 0 } // End of options.
};


int main(int argc,char *argv[]) {
  progname=argv[0];
  KAboutData about(progname,applicationName,version,comment,license,copyright,text,homepage,bugemail);
  about.addAuthor("Peter Brueckner","developer","peter@bj-ig.de");
  about.addAuthor("Ralf Mueller","tester","ralf@bj-ig.de");
  KCmdLineArgs::init(argc,argv,&about);
  KCmdLineArgs::addCmdLineOptions(options);
  KCmdLineArgs *args=KCmdLineArgs::parsedArgs();
  if(args->isSet("V")) {
    printf("%s: Version %s\n",progname,version);
    exit(0);
  }
  if(args->isSet("v")) {
    verbose++; 
  }
  if(args->isSet("i")) {
    interactive=1;
  }
  if(args->isSet("p")) {
    pipemode=1;
  }
  if(args->isSet("d")) {
    dodebug=1;
  }
  KdeTclApplication application;
  int somethingdone=0;
  if(args->isSet("c")) {
    somethingdone=1;
    QCStringList l=args->getOptionList("c");
    QCStringList::iterator it;
    for(it=l.begin();it!=l.end();++it) {
      if(application.qinterp()->eval((char*)((const char*)(*it)))) {
        fprintf(stderr,"%s: %s\n",progname,(const char*)application.qinterp()->result());
        exit(1);
      }
    }
  }
  for(int i=0;i<args->count();i++) {
    somethingdone=1;
    if(application.qinterp()->evalFile((const char*)(args->arg(i)))) {
      fprintf(stderr,"%s: %s\n",progname,(const char*)application.qinterp()->result());
      exit(1);
    }
  }
  args->clear();
  if(!somethingdone && !dodebug) interactive=1;
  if(pipemode) {
     application.qinterp()->setInteractive(1);
  } else {
    if(interactive) application.qinterp()->setInteractive(isatty(0)?2:1);
  }
  if(dodebug) application.qinterp()->setDebug(dodebug);
  return application.exec();
}
