extern "C" {
#include <tcl.h>
}
#include <QObject>
#include <QAction>

#include "QTclInterp.h"
#include "QTclObject.h"
#include "QTclUtil.h"
#include "QTclFactory.h"

#include "QTclAction.h"

//------------------ Factory for QActions -------------------------------

class QTclQtActionFactory : public QTclFactory {
public:
  virtual QObject *create(const QString& className,QObject *parent) {
    if(className=="QAction") return new QAction(parent);
    if(className=="QActionGroup") return new QActionGroup(parent);
    return 0;
  }
  virtual QStringList classNames() {
    const char *clNames[]= { "QAction", "QActionGroup" };
    return QTclCreateQStringList(QTCLARSIZE(clNames),clNames);
  }
};

//------------------ Commands for QActions -------------------------------

static int QTclActionMethods(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
//QAction *a=(QAction*)clientData;
  return QTclObjectMethods(clientData,interp,argc,argv);
}

static int QTclActionGroupMethods(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
//QActionGroup *a=(QActionGroup*)clientData;
  return QTclObjectMethods(clientData,interp,argc,argv);
}

int QTclInitAction(QTclInterp * /*qinterp*/) {
  QTclInterp::registerMethods("QAction",&QTclActionMethods);
  QTclInterp::registerMethods("QActionGroup",&QTclActionGroupMethods);
  QTclInterp::registerFactory(new QTclQtActionFactory);
  return TCL_OK;
}
