extern "C" {
#include <tcl.h>
}

#include <QApplication>
#include <QClipboard>

#include "QTclUtil.h"
#include "QTclInterp.h"
#include "QTclObject.h"

#include "QTclApplication.h"

int QTclApplicationMethods(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
QApplication *w=(QApplication*)clientData;
  if(argc<2) {
    Tcl_AppendElement(interp,"libraryPaths");
    if(argc<1) return TCL_OK;
  } else if(argc==2 && !strcmp(argv[1],"libraryPaths")) {
    Tcl_AppendQStringList(interp,w->libraryPaths());
    return TCL_OK;
  } else if(argc==3 && !strcmp(argv[1],"addLibraryPath")) {
    w->addLibraryPath(QTclC2S(argv[2]));
    Tcl_AppendQStringList(interp,w->libraryPaths());
    return TCL_OK;
  } else if(argc==3 && !strcmp(argv[1],"removeLibraryPath")) {
    w->removeLibraryPath(QTclC2S(argv[2]));
    Tcl_AppendQStringList(interp,w->libraryPaths());
    return TCL_OK;
  } else if(argc>2 && !strcmp(argv[1],"setLibraryPaths")) {
    w->setLibraryPaths(QTclCreateQStringList(argc-2,(const char **)(argv+2)));
    Tcl_AppendQStringList(interp,w->libraryPaths());
    return TCL_OK;
  }
  return QTclObjectMethods(clientData,interp,argc,argv);
}

int QTclApplicationClassMethods(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
//QTclInterp *qinterp=(QTclInterp*)clientData;
  if(argc<2) return Tcl_WrongArgs(interp,1,argv,"clipboard");
  if(!strcmp(argv[1],"clipboard")) {
    QTclInterp::appendName(interp,QApplication::clipboard());
    return TCL_OK;
  }
  return Tcl_WrongArgs(interp,1,argv,"command");
}
 
int QTclInitApplication(QTclInterp * /*qinterp*/) {
  QTclInterp::registerMethods("QApplication",&QTclApplicationMethods);
  QTclInterp::registerClassMethods("QApplication",&QTclApplicationClassMethods);
  return TCL_OK;
}
