extern "C" {
#include <stdio.h>
#include <tcl.h>
}
#include <QList>
#include <QFont>

#include "QTclUtil.h"
#include "QTclInterp.h"

#include "QTclBind.h"


QTclBinding::QTclBinding(QObject *parent0,const char *sig0,Tcl_Interp *interp0,const char *cmd0):
  QTclCommand(parent0,sig0,interp0,cmd0) {
}

void QTclBinding::binding(void) {
  QTclInterp::eval(interp(),command());
}

void QTclBinding::binding(const QString& arg) {
  QTclInterp::eval(interp(),command(),arg);
}

void QTclBinding::binding(int arg) {
  QTclInterp::eval(interp(),command(),QString::number(arg));
}

void QTclBinding::binding(bool arg) {
  QTclInterp::eval(interp(),command(),QString(arg?"true":"false"));
}

void QTclBinding::binding(const QFont&f) {
  QTclInterp::eval(interp(),command(),f.toString());
}

int QTclBinding::bind(Tcl_Interp *interp,QObject *o,const char *signalname,int argc,char *argv[]) {
int result=TCL_OK;
  Tcl_DString d;
  Tcl_DStringInit(&d);
  for(int i=0;i<argc;i++) {
    if(i) Tcl_DStringAppend(&d," ",1);
    Tcl_DStringAppend(&d,argv[i],-1);
  }
  QTclBinding *b=new QTclBinding(o,signalname,interp,Tcl_DStringValue(&d));
  Tcl_DStringFree(&d);
  const char *signature=strchr(signalname,'(');
  if(!signature) signature="()";
  Tcl_DString si;
  Tcl_DStringInit(&si);
  Tcl_DStringAppend(&si,"2",1);
  Tcl_DStringAppend(&si,signalname,-1);
  Tcl_DString sl;
  Tcl_DStringInit(&sl);
  Tcl_DStringAppend(&sl,"1",1);
  Tcl_DStringAppend(&sl,"binding",-1);
  Tcl_DStringAppend(&sl,signature,-1);
  if(!QObject::connect(o,Tcl_DStringValue(&si),b,Tcl_DStringValue(&sl))) {
    Tcl_DStringTrunc(&sl,1);
    Tcl_DStringAppend(&sl,"binding()",-1);
    if(!QObject::connect(o,Tcl_DStringValue(&si),b,Tcl_DStringValue(&sl))) {
      delete b;
      Tcl_AppendResult(interp,"wrong signature or not implemented '",signature,"'",0);
      result=TCL_ERROR;
    }
  }
  Tcl_DStringFree(&si);
  Tcl_DStringFree(&sl);
  return result;
}

int QTclBinding::find(Tcl_Interp *interp,QObject *o,const char *id,QTclBinding **result) {
  *result=o->findChild<QTclBinding*>(id);
  if(!(*result)) {
    Tcl_AppendResult(interp,"binding not found '",id,"'",0);
    return TCL_ERROR;
  }
  return TCL_OK;
}

int QTclBinding::unbind(Tcl_Interp *interp,QObject *o,const char *id) {
QTclBinding *p;
  if(find(interp,o,id,&p)!=TCL_OK) return TCL_ERROR;
  delete p;
  return TCL_OK;
}

int QTclBinding::info(Tcl_Interp *interp,QObject *o,const char *id) {
QTclBinding *p;
  if(!find(interp,o,id,&p)) return TCL_ERROR;
  Tcl_AppendQString(interp,p->command());
  return TCL_OK;
}

int QTclBinding::list(Tcl_Interp *interp,QObject *o) {
  QTclInterp::appendChildren(interp,o,FALSE,"QTclBinding");
  return TCL_OK;
}

#include "moc_QTclBind.cpp"
