#ifndef __QBIND_H__
#define __QBIND_H__

struct Tcl_Interp;

#include "QTclCommand.h"

class QTclBinding : public QTclCommand {
  Q_OBJECT
  Q_PROPERTY(QString signal READ signal)
public:
  QTclBinding(QObject *parent,const char *signal,Tcl_Interp *interp,const char *command);
  const QString &signal() const { return _signal; }
private:
  QString _signal;
protected slots:
  void binding();
  void binding(int);
  void binding(bool);
  void binding(const QString&);
  void binding(const QFont&);
  // Add extra bindings here
public:
  static int bind(Tcl_Interp *interp,QObject *w,const char *signal,int argc,char *argv[]);
  static int unbind(Tcl_Interp *interp,QObject *w,const char *signal);
  static int info(Tcl_Interp *interp,QObject *w,const char *signal);
  static int list(Tcl_Interp *interp,QObject *w);
  static int find(Tcl_Interp *interp,QObject *o,const char *id,QTclBinding **result);
};

#endif
