extern "C" {
#include <tcl.h>
}

#ifdef LATER
#include <QObject>

#include "QTclInterp.h"
#include "QTclObject.h"
#include "QTclUtil.h"
#include "QTclFactory.h"

#include "QTclCanvas.h"

//------------------ Factory for QCanvas -------------------------------

class QTclQtCanvasFactory : public QTclFactory {
public:
  virtual QObject *create(const QString& className,QObject *parent,const char *name) {
    if(className=="QCanvas") return new QCanvas(parent,name);
    return 0;
  }
  virtual QStringList classNames() {
    const char *clNames[]= { "QCanvas" };
    return QTclCreateQStringList(QTCLARSIZE(clNames),clNames);
  }
};

//------------------ Factory for QCanvasItem -------------------------------

class QTclQtCanvasItemFactory {
public:
  virtual QCanvasItem *create(QString className,QCanvas *parent,const char * /*name*/) {
    if(className=="QCanvasSprite") return new QCanvasRectangle(parent);
    if(className=="QCanvasText") return new QCanvasRectangle(parent);
    if(className=="QCanvasRectangle") return new QCanvasRectangle(parent);
    if(className=="QCanvasPolygon") return new QCanvasRectangle(parent);
    if(className=="QCanvasLine") return new QCanvasRectangle(parent);
    if(className=="QCanvasEllipse") return new QCanvasRectangle(parent);
    return 0;
  }
  virtual QStringList classNames() {
    const char *clNames[]= {
      "QCanvasSprite",
      "QCanvasText",
      "QCanvasRectangle",
      "QCanvasPolygon",
      "QCanvasLine",
      "QCanvasEllipse"
    };
    return QTclCreateQStringList(QTCLARSIZE(clNames),clNames);
  }
};

//----------------------------------------------------------------------

static void QTclAppendCanvasItem(Tcl_Interp *interp,QCanvasItem *item) {
char buffer[100];
  sprintf(buffer,"CI%p",(void*)item);
  Tcl_AppendElement(interp,buffer);
}

static int QTclGetCanvasItem(Tcl_Interp *interp,const char *value,QCanvasItem **itemPtr) {
  if(sscanf(value,"CI%p",(void**)itemPtr)!=1) {
    Tcl_AppendResult(interp,"invalid canvasitem:'",value,"'",0);
    return TCL_ERROR;
  }
  return TCL_OK;
}

static int QTclCheckCanvasItem(Tcl_Interp *interp,QCanvas *canvas,QCanvasItem *item) {
QCanvasItemList all=canvas->allItems();
  for(QCanvasItemList::Iterator it=all.begin();it!=all.end();++it) {
     if(*it==item) return TCL_OK;
  }
  Tcl_AppendResult(interp,"item not in canvas:'",0);
  QTclAppendCanvasItem(interp,item);
  Tcl_AppendResult(interp,"'",0);
  return TCL_ERROR;
}

static int QTclConfigureCanvasItem(Tcl_Interp *interp,QCanvasItem *item,int argc,char *argv[]) {
  for(int i=0;i<argc;i++) {
    if(!strcmp(argv[i],"move")) {
      if(argc>3) {
        double x;
        double y;
        if(Tcl_GetDouble(interp,argv[1],&x)!=TCL_OK) return TCL_ERROR;
        if(Tcl_GetDouble(interp,argv[2],&y)!=TCL_OK) return TCL_ERROR;
        item->move(x,y);
        i+=2;
        continue;
      }
    } else if(!strcmp(argv[i],"show")) {
      item->show();
    //} else if(!strcmp(argv[i],"xxxxx")) {
    //  item->allTheOthenItemMethods;
    }
    Tcl_WrongArgs(interp,argc,argv,"configure canvas item ");
    return TCL_ERROR;
  }
  return TCL_OK;
}

//------------------ Commands for QCanvas  -------------------------------

static int QTclCanvasMethods(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
static QTclQtCanvasItemFactory itemFactory;
QCanvas *w=(QCanvas*)clientData;
  if(argc<2) {
    Tcl_AppendElement(interp,"backgroundColor");
    Tcl_AppendElement(interp,"createitem");
    Tcl_AppendElement(interp,"destroyitem");
    Tcl_AppendElement(interp,"configureitem");
    if(argc<1) return TCL_OK;
  } else if(!strcmp(argv[1],"backgroundColor")) {
    switch(argc) {
      case 2:
        Tcl_AppendElement(interp,w->backgroundColor().name());
        return TCL_OK;
      case 3:
        w->setBackgroundColor(QColor(argv[3]));
        return TCL_OK;
    }
    return Tcl_WrongArgs(interp,argc,argv,"backgroundColor [<color>]");
  //} else if(!strcmp(argv[1],"xxxxxx")) {
  // TODO implement all the canvas methods needed
  //return TCL_OK;
  } else if(!strcmp(argv[1],"createitem")) {
    if(argc<3) return Tcl_WrongArgs(interp,argc,argv,"createItem <type> [<arguments>]");
    QCanvasItem *item=itemFactory.create(argv[2],w,"");
    if(!item) {
       Tcl_AppendResult(interp,"error creating canvas item '",argv[2],"'",0);
       return TCL_ERROR;
    }
    if(QTclConfigureCanvasItem(interp,item,argc-3,argv+3)!=TCL_OK) return TCL_ERROR;
    QTclAppendCanvasItem(interp,item);
    return TCL_OK;
  } else if(!strcmp(argv[1],"destroyitem")) {
    if(argc<3) return Tcl_WrongArgs(interp,argc,argv,"destroyitem <items>");
    for(int i=2;i<argc;i++) {
      QCanvasItem *item;
      if(QTclGetCanvasItem(interp,argv[i],&item)!=TCL_OK) return TCL_ERROR;
      if(QTclCheckCanvasItem(interp,w,item)) return TCL_ERROR;
      delete item;
    }
    return TCL_OK;
  } else if(!strcmp(argv[1],"configureitem")) {
    if(argc<3) return Tcl_WrongArgs(interp,argc,argv,"configureitem <arguments>");
    QCanvasItem *item;
    if(QTclGetCanvasItem(interp,argv[2],&item)!=TCL_OK) return TCL_ERROR;
    if(QTclCheckCanvasItem(interp,w,item)) return TCL_ERROR;
    if(QTclConfigureCanvasItem(interp,item,argc-3,argv+3)!=TCL_OK) return TCL_ERROR;
    return TCL_OK;
  }
  return QTclObjectMethods(clientData,interp,argc,argv);
}

int QTclInitCanvas(QTclInterp * /*qinterp*/) {
  QTclInterp::registerMethods("QCanvas",&QTclCanvasMethods);
  QTclInterp::registerFactory(new QTclQtCanvasFactory);
  return TCL_OK;
}

#endif
