#ifndef __QTCLCREATOR_H_
#define __QTCLCREATOR_H_

#include <QTclInterp.h>
#include <QTclObject.h>

template class <class F> class QTclCreator {
public:
  static int createObjectFromPath(ClientData *clientData,Tcl_Interp *interp,int argc,char *argv[]) {
  QInterp *qinterp=(QInterp*)clientData;
    switch(argc) {
      case 3:
        return Tcl_WrongArgs(interp,2,argv,"<className> <name> [ <property> <value> ] .. "); 
      case 2:
        Tcl_AppendQStringList(interp,F::classNames());
        return TCL_OK;
    }
    QObject *parent;
    char name[1024];
    if(QTclInterp::prepareForCreate(interp,argv[3],0,&parent,name,sizeof(name))!=TCL_OK) {
      return TCL_ERROR;
    }
    QObject *w=F::create(argv[2],parent,name);
    if(!w) {
      Tcl_AppendResult(interp,"error creating object '",argv[2],"' name '",argv[3],"'",0);
      return TCL_ERROR;
    }
    if(QTclSetProperties(interp,w,argc-4,argv+4)!=TCL_OK) {
      delete w;
      return TCL_ERROR;
    }
    QTclInterp::appendName(interp,w);
    return TCL_OK;
  }
};

#endif
