extern "C" {
#include <stdio.h>
#include <stdarg.h>
#include <tcl.h>
}

//#include <Qt>
#include <QEvent>
#include <QMouseEvent>

#include "QTclUtil.h"
#include "QTclInterp.h"

#include "QTclEvent.h"

static QTclNameTable eventTypeNameTable[] = {
  { "Timer", 1},
  { "MouseButtonPress", 2},
  { "MouseButtonRelease", 3},
  { "MouseButtonDblClick", 4},
  { "MouseMove", 5},
  { "KeyPress", 6},
  { "KeyRelease", 7},
  { "FocusIn", 8},
  { "FocusOut", 9},
  { "Enter", 10},
  { "Leave", 11},
  { "Paint", 12},
  { "Move", 13},
  { "Resize", 14},
  { "Create", 15},
  { "Destroy", 16},
  { "Show", 17},
  { "Hide", 18},
  { "Close", 19},
  { "Quit", 20},
  { "Reparent", 21},
  { "ShowMinimized", 22},
  { "ShowNormal", 23},
  { "WindowActivate", 24},
  { "WindowDeactivate", 25},
  { "ShowToParent", 26},
  { "HideToParent", 27},
  { "ShowMaximized", 28},
  { "ShowFullScreen", 29},
  { "Accel", 30},
  { "Wheel", 31},
  { "AccelAvailable", 32},
  { "CaptionChange", 33},
  { "IconChange", 34},
  { "ParentFontChange", 35},
  { "ApplicationFontChange", 36},
  { "ParentPaletteChange", 37},
  { "ApplicationPaletteChange", 38},
  { "PaletteChange", 39},
  { "Clipboard", 40},
  { "Speech", 42},
  { "SockAct", 50},
  { "AccelOverride", 51},
  { "DeferredDelete", 52},
  { "DragEnter", 60},
  { "DragMove", 61},
  { "DragLeave", 62},
  { "Drop", 63},
  { "DragResponse", 64},
  { "ChildInserted", 70},
  { "ChildRemoved", 71},
  { "LayoutHint", 72},
  { "ShowWindowRequest", 73},
  { "ActivateControl", 80},
  { "DeactivateControl", 81},
  { "ContextMenu", 82},
  { "IMStart", 83},
  { "IMCompose", 84},
  { "IMEnd", 85},
  { "Accessibility", 86},
  { "Tablet", 87},
  { "TabletMove" , 87},
  { "LocaleChange" , 88},
  { "LanguageChange" , 89},	
  { "LayoutDirectionChange" , 90},
  { "Style" , 91},
  { "TabletPress" , 92},
  { "TabletRelease" , 93},
  { "OkRequest",   94},                         // CE (Ok) button pressed
  { "HelpRequest",   95},                       // CE (?)  button pressed
  { "WindowStateChange", 96},                 // window state has changed
  { "IconDrag",   97},                          // proxy icon dragged
  { "User",   1000},                            // first user event id
  { "MaxUser",   65535}                         // last user event id
};

static QTclNameTable buttonStateNameTable[] = {
  { "NoButton", 0x0000},
  { "LeftButton", 0x0001},
  { "RightButton", 0x0002},
  { "MidButton", 0x0004},
  { "XButton1", 0x0008},
  { "XButton2", 0x0010},
  //{ "MouseButtonMask", 0x00ff},
  { "ShiftButton", 0x0100},
  { "ControlButton", 0x0200},
  { "AltButton", 0x0400},
  { "MetaButton", 0x0800},
  //{ "KeyButtonMask", 0x0fff},
  { "Keypad", 0x4000 }
};

static QTclNameTable reasonNameTable[] = {
 { "Mouse", 0 },
 { "Tab", 1 },
 { "Backtab", 2 },
 { "ActiveWindow", 3 },
 { "Popup", 4 },
 { "Shortcut", 5 },
 { "Other" ,6 }
};

static QTclNameTable modifierNameTable[] = {
  { "NoModifier",     Qt::NoModifier },
  { "ShiftModifier",  Qt::ShiftModifier },
  { "ControlModifier",Qt::ControlModifier },
  { "AltModifier",    Qt::AltModifier },
  { "MetaModifier",   Qt::MetaModifier },
  { "KeypadModifier", Qt::KeypadModifier }
};

static void Tcl_DStringAppendEventInfo(Tcl_DString *d,QEvent *e) {
  Tcl_DStringAppendEnumInfo(d,"type",e->type(),eventTypeNameTable,QTCLARSIZE(eventTypeNameTable));
  switch(e->type()) {
    case QEvent::MouseMove:
    case QEvent::MouseButtonPress:
    case QEvent::MouseButtonRelease:
    case QEvent::MouseButtonDblClick: {
      QMouseEvent *me=(QMouseEvent*)e;
      Tcl_DStringAppendIntInfo(d,"x",me->x());
      Tcl_DStringAppendIntInfo(d,"y",me->y());
      Tcl_DStringAppendIntInfo(d,"globalX",me->globalX());
      Tcl_DStringAppendIntInfo(d,"globalY",me->globalY());
      Tcl_DStringAppendEnumInfo(d,"button",me->button(),buttonStateNameTable,QTCLARSIZE(buttonStateNameTable));
      Tcl_DStringAppendSetInfo(d,"buttons",me->buttons(),buttonStateNameTable,QTCLARSIZE(buttonStateNameTable));
      Tcl_DStringAppendBoolInfo(d,"isAccepted",me->isAccepted());
      Tcl_DStringAppendSetInfo(d,"modifiers",me->modifiers(),modifierNameTable,QTCLARSIZE(modifierNameTable));
      break;
    }
    case QEvent::KeyPress:
    case QEvent::KeyRelease: {
      QKeyEvent *ke = (QKeyEvent *)e;
      Tcl_DStringAppendBoolInfo(d,"isAccepted",ke->isAccepted());
      Tcl_DStringAppendIntInfo(d,"count",ke->count());
      Tcl_DStringAppendBoolInfo(d,"isAutoRepeat",ke->isAutoRepeat());
      Tcl_DStringAppendIntInfo(d,"key",ke->key());
      Tcl_DStringAppendSetInfo(d,"modifiers",ke->modifiers(),modifierNameTable,QTCLARSIZE(modifierNameTable));
      Tcl_DStringAppendQStringInfo(d,"text",ke->text());
      break;
    }
    case QEvent::FocusIn: 
    case QEvent::FocusOut: {
      QFocusEvent *fe = (QFocusEvent *)e;
      Tcl_DStringAppendEnumInfo(d,"reason",fe->reason(),reasonNameTable,QTCLARSIZE(reasonNameTable));
      break;
    }
    case QEvent::WindowActivate:
    case QEvent::WindowDeactivate:
    case QEvent::Enter:
    case QEvent::Leave:
    case QEvent::Show:
    case QEvent::Hide: {
      break;
    }
    case QEvent::Close: {
      QCloseEvent *ce = (QCloseEvent *)e;
      Tcl_DStringAppendBoolInfo(d,"isAccepted",ce->isAccepted());
      break;
    }
    case QEvent::Move: {
      QMoveEvent *me = (QMoveEvent *)e;
      Tcl_DStringAppendIntInfo(d,"x",me->pos().x()); 
      Tcl_DStringAppendIntInfo(d,"y",me->pos().y()); 
      Tcl_DStringAppendIntInfo(d,"oldX",me->oldPos().x()); 
      Tcl_DStringAppendIntInfo(d,"oldY",me->oldPos().y()); 
      break;
    }
    case QEvent::Resize: {
      QResizeEvent *re = (QResizeEvent *)e;
      Tcl_DStringAppendIntInfo(d,"width",re->size().width()); 
      Tcl_DStringAppendIntInfo(d,"height",re->size().height()); 
      Tcl_DStringAppendIntInfo(d,"oldWidth",re->oldSize().width()); 
      Tcl_DStringAppendIntInfo(d,"oldHeight",re->oldSize().height()); 
      break;
    }
    case QEvent::Paint:
    case QEvent::ContextMenu:
    case QEvent::Drop:
    case QEvent::DragEnter:
    case QEvent::DragMove:
    case QEvent::DragLeave:
    case QEvent::ShowWindowRequest:
    case QEvent::ApplicationFontChange:
    case QEvent::ApplicationPaletteChange:
    case QEvent::None:
    case QEvent::Timer:
    case QEvent::Create:
    case QEvent::Destroy:
    case QEvent::Quit:
    case QEvent::Wheel:
    case QEvent::PaletteChange:
    case QEvent::Clipboard:
    case QEvent::Speech:
    case QEvent::SockAct:
    case QEvent::DeferredDelete:
    case QEvent::DragResponse:
    case QEvent::ChildRemoved:
    case QEvent::ActivateControl:
    case QEvent::DeactivateControl:
    case QEvent::TabletMove:
    case QEvent::LocaleChange:
    case QEvent::LanguageChange:
    case QEvent::LayoutDirectionChange:
    case QEvent::Style:
    case QEvent::TabletPress:
    case QEvent::TabletRelease:
    case QEvent::User:
    case QEvent::MaxUser:
    case QEvent::WindowBlocked:
    case QEvent::WindowUnblocked:
    case QEvent::OkRequest:
    case QEvent::HelpRequest:
    case QEvent::WindowStateChange: 
    case QEvent::IconDrag: 
    case QEvent::ParentAboutToChange:
    case QEvent::ThreadChange:
    case QEvent::ShowToParent:
    case QEvent::HideToParent:
    case QEvent::WindowTitleChange:
    case QEvent::WindowIconChange:
    case QEvent::ApplicationWindowIconChange:
    case QEvent::ApplicationLayoutDirectionChange:
    case QEvent::MetaCall:
    case QEvent::WinEventAct:
    case QEvent::ChildAdded:
    case QEvent::ChildPolished:
    case QEvent::PolishRequest:
    case QEvent::Polish:
    case QEvent::LayoutRequest:
    case QEvent::UpdateRequest:
    case QEvent::EmbeddingControl:
    case QEvent::InputMethod:
    case QEvent::AccessibilityPrepare:
    case QEvent::FontChange:
    case QEvent::EnabledChange:
    case QEvent::ActivationChange:
    case QEvent::ParentChange: 
    case QEvent::StyleChange:
    case QEvent::IconTextChange:
    case QEvent::ModifiedChange:
    case QEvent::MouseTrackingChange:
    case QEvent::ToolTip:
    case QEvent::WhatsThis:
    case QEvent::StatusTip:
    case QEvent::ActionChanged:
    case QEvent::ActionAdded:
    case QEvent::ActionRemoved:
    case QEvent::FileOpen:
    case QEvent::Shortcut:
    case QEvent::ShortcutOverride:
    case QEvent::WhatsThisClicked:
    case QEvent::ToolBarChange:
    case QEvent::ApplicationActivated:
    case QEvent::ApplicationDeactivated:
    case QEvent::QueryWhatsThis:
    case QEvent::EnterWhatsThisMode:
    case QEvent::LeaveWhatsThisMode:
    case QEvent::ZOrderChange:
    case QEvent::HoverEnter:
    case QEvent::HoverLeave:
    case QEvent::HoverMove:
    case QEvent::AccessibilityHelp:
    case QEvent::AccessibilityDescription:
    case QEvent::UpdateLater:
    case QEvent::AcceptDropsChange:
    case QEvent::MenubarUpdated:
    case QEvent::ZeroTimerEvent:
    {
      //LATER
      break;
    }
  }
}

QTclEvent::QTclEvent(QObject *parent,const QString &name,Tcl_Interp *interp,const QString &command): QTclCommand(parent,name,interp,command) {
}

QTclEvent::~QTclEvent() {
}

bool QTclEvent::eventFilter(QObject *o,QEvent *e) {
const QObject *s=sender();
QString rname=QTclInterp::name(o);
QString sname=QTclInterp::name(s);
Tcl_DString d;
  Tcl_DStringInit(&d);
  Tcl_DStringAppendEventInfo(&d,e);
  QTclInterp::eval(interp(),command(),rname,Tcl_DStringValue(&d),sname);
  Tcl_DStringFree(&d);
  return FALSE;
}

static QTclEvent *findEventHandler(QObject *o) {
  return o->findChild<QTclEvent*>("event");
}

int QTclEvent::event(Tcl_Interp *interp,QObject *w,int argc,char *argv[]) {
QTclEvent *e=findEventHandler(w);
  if(argc==0) {
    if(e) {
      Tcl_AppendQString(interp,e->command());
    }
    return TCL_OK;
  }
  Tcl_DString d;
  Tcl_DStringInit(&d);
  for(int i=0;i<argc;i++) {
    if(i) Tcl_DStringAppend(&d," ",1);
    Tcl_DStringAppend(&d,argv[i],-1);
  }
  if(e) {
    w->removeEventFilter(e);
    delete e;
  }
  if(Tcl_DStringLength(&d)) {
    e=new QTclEvent(w,"event",interp,Tcl_DStringValue(&d));
    w->installEventFilter(e);
  }
  return TCL_OK;
}

#include "moc_QTclEvent.cpp"
