extern "C" {
#include <tcl.h>
#include <string.h>
}

#include <QtGui/QFileDialog>

#include "QTclUtil.h"
#include "QTclInterp.h"
#include "QTclWidget.h"

#include "QTclFileDialog.h"

#ifdef LATER
static QTclNameTable optionNameTable[] = {
  { "ShowDirsOnly",         QFileDialog::ShowDirsOnly  },
  { "DontResolveSymlinks",  QFileDialog::DontResolveSymlinks },
  { "DontConfirmOverwrite", QFileDialog::DontConfirmOverwrite },
  { "DontUseSheet",         QFileDialog::DontUseSheet },
  { "DontUseNativeDialog",  QFileDialog::DontUseNativeDialog }
};
#endif

static int QTclFileDialogClassMethods(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
QTclInterp *qinterp=(QTclInterp*)clientData;
QString startWith=QString::null;
QString filter=QString::null;
QString dir=QString::null;
QWidget *parent=0;
QString caption=QString::null;
QString selectedFilter=QString::null;
QFileDialog::Options options=0;
int resolveSymlinks=TRUE;
int dirOnly=TRUE;
  if(argc<2) return Tcl_WrongArgs(qinterp->interp(),1,argv,"getOpenFileName|getSaveFileName|getExistingDirectory|getOpenFilenames [-parent <widget>] [-caption <caption>] [-resolveSymlinks <bool>] [-dir <dir>] [-dirOnly <bool>]");
  for(int i=2;i+1<argc;i+=2) {
    if(!strcmp(argv[i],"startWith")) {
      startWith=argv[i+1];
    } else if(!strcmp(argv[i],"filter")) {
      filter=argv[i+1];
    } else if(!strcmp(argv[i],"dir")) {
      dir=argv[i+1];
    } else if(!strcmp(argv[i],"parent")) {
      if(QTclInterp::getWidgetByName(interp,argv[i+1],&parent)!=TCL_OK) return TCL_ERROR;
    } else if(!strcmp(argv[i],"caption")) {
      caption=argv[i+1];
    } else if(!strcmp(argv[i],"resolveSymlinks")) {
      if(Tcl_GetBoolean(interp,argv[i+1],&resolveSymlinks)!=TCL_OK) return TCL_ERROR;
    } else if(!strcmp(argv[i],"dirOnly")) {
      if(Tcl_GetBoolean(interp,argv[i+1],&dirOnly)!=TCL_OK) return TCL_ERROR;
    }
  }
  if(!strcmp(argv[1],"getOpenFileName")) {
    Tcl_AppendQString(interp,QFileDialog::getOpenFileName(parent,caption,dir,filter,&selectedFilter,options));
  } else if(!strcmp(argv[1],"getSaveFileName")) {
    Tcl_AppendQString(interp,QFileDialog::getSaveFileName(parent,caption,dir,filter,&selectedFilter,options));
  } else if(!strcmp(argv[1],"getExistingDirectory")) {
    Tcl_AppendQString(interp,QFileDialog::getExistingDirectory(parent,caption,dir,options));
  } else if(!strcmp(argv[1],"getOpenFileNames")) {
    Tcl_AppendQStringList(interp,QFileDialog::getOpenFileNames(parent,caption,dir,filter,&selectedFilter,options));
  } else {
    return Tcl_WrongArgs(interp,1,argv,"getOpenFileName|getSaveFileName|getExistingDirectory|getOpenFilenames");
  }
  return TCL_OK;
}


static int QTclFileDialogMethods(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
//QFileDialog *e=(QFileDialog *)clientData;
  if(argc<2) {
    Tcl_AppendElement(interp,"xxx");
    if(argc<1) return TCL_OK;
  } else if(!strcmp(argv[1],"xxx")) {
    //return QTclFileeventRead(interp,e->name());
    return TCL_OK;
  }
  return QTclDialogMethods(clientData,interp,argc,argv);
}

int QTclInitFileDialog(QTclInterp */*qinterp*/) {
  QTclInterp::registerMethods("QFileDialog",&QTclFileDialogMethods);
  QTclInterp::registerClassMethods("QFileDialog",&QTclFileDialogClassMethods);
  return TCL_OK;
}
