extern "C" {
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <tcl.h>
#ifdef _WIN32
#include "QTclWin32Compat.h"
#else
#include "unistd.h"
#endif
}


#include <QObjectList>
#include <QSocketNotifier>

#include "QTclInterp.h"
#include "QTclUtil.h"
#include "QTclObject.h"

#include "QTclFileevent.h"

int QTclFileevent::fileeventId=0;

QTclFileevent::QTclFileevent(QTclInterp *parent,const QString &name,int fd,QSocketNotifier::Type type,const QString& command)
  :QTclCommand(parent,name,parent->interp(),command) {
  qSocketNotifier=new QSocketNotifier(fd,type,this);
  qSocketNotifier->setObjectName(name);
  connect(qSocketNotifier,SIGNAL(activated(int)),this,SLOT(fire(int)));
}

void QTclFileevent::fire(int /*fd*/) {
  QTclInterp::eval(interp(),command(),objectName());
}

int QTclFileevent::fd() const {
  return qSocketNotifier->socket();
}

static int getModeFromString(Tcl_Interp*interp,const char *str,QSocketNotifier::Type *typePtr) {
  if(!strcmp(str,"readable")) {
    *typePtr=QSocketNotifier::Read;
    return TCL_OK;
  }
  if(!strcmp(str,"writable")) {
    *typePtr=QSocketNotifier::Write;
    return TCL_OK;
  }
  if(!strcmp(str,"exception")) {
    *typePtr=QSocketNotifier::Exception;
    return TCL_OK;
  }
  Tcl_AppendResult(interp,"readable,writable or exception expected",0);
  return TCL_ERROR;
}

static int getChannelFD(Tcl_Interp *interp,const QString &channelName,int *result) {
#if TCL_MAJOR_VERSION>7
Tcl_Channel channel;
  if(!(channel=Tcl_GetChannel(interp,QTclS2C(channelName),0))) {
    return TCL_ERROR;
  }
  if(Tcl_GetChannelHandle(channel,TCL_READABLE,(ClientData *)result)!=TCL_OK) {
    return TCL_ERROR;
  }
  return TCL_OK;
#else
  FILE *f;
  if(Tcl_GetOpenFile(interp,QTclS2C(channelName),0,0,&f)!=TCL_OK) {
    return TCL_ERROR;
  }
  setvbuf(f,0,_IONBF,0);
  *result=fileno(f);
  return TCL_OK;
  //int mode=fcntl(fd,F_GETFL);
  //fcntl(fd,F_SETFL,mode | O_NONBLOCK);
#endif
}

static int QTclFileeventRead(Tcl_Interp *interp,const QString &ident) {
char buffer[0x10001];
int fd;
  if(getChannelFD(interp,ident,&fd)!=TCL_OK) return TCL_ERROR;
  int count=read(fd,buffer,sizeof(buffer)-1);
  if(!count) {
    if(errno) {
      Tcl_PosixError(interp);
      return TCL_ERROR;
    } else {
      Tcl_ResetResult(interp);
      return TCL_OK;
    }
  }
  buffer[count]=0; // Terminating 0
  Tcl_AppendResult(interp,buffer,0);
  return TCL_OK;
}

static int QFileeventMethods(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
QTclInterp *qinterp=(QTclInterp*)clientData;
  switch(argc) {
    case 0:
    case 1:
      break;
    case 2:
      if(!strcmp(argv[1],"info")) {
        QTclInterp::appendChildren(interp,qinterp,FALSE,"QTclFileevent");
        return TCL_OK;
      }
      break;
    case 3:
      if(!strcmp(argv[1],"read")) {
        return QTclFileeventRead(interp,argv[2]);
      } else if(!strcmp(argv[1],"cancel")) {
        QObject *p;
        if(QTclInterp::getObjectByName(interp,argv[2],&p,"QTclFileevent")!=TCL_OK) return TCL_ERROR;
        delete p;
        return TCL_OK;
      } else if(!strcmp(argv[1],"info")) {
        QTclFileevent *p;
        if(QTclInterp::getObjectByName(interp,argv[2],(QObject**)&p,"QTclFileevent")!=TCL_OK) return TCL_ERROR;
        Tcl_AppendQString(interp,p->command());
      } 
      //NOBREAK
    default:
      int fd;
      QSocketNotifier::Type type;
      if(getModeFromString(interp,argv[2],&type)!=TCL_OK) return TCL_ERROR;
      if(getChannelFD(interp,argv[1],&fd)!=TCL_OK) return TCL_ERROR; 
      Tcl_DString d;
      Tcl_DStringInit(&d);
      for(int i=3;i<argc;i++) {
        if(i!=3) Tcl_DStringAppend(&d," ",1);
        Tcl_DStringAppend(&d,argv[i],-1);
      }
      QTclFileevent*t=new QTclFileevent(qinterp,argv[1],fd,type,Tcl_DStringValue(&d));
      Tcl_DStringFree(&d);
      QTclInterp::appendName(interp,t);
      return TCL_OK;
  }
  return Tcl_WrongArgs(interp,1,argv,"file <readable|writable> <cmd>|cancel id|info id|info");
}

static int QTclFileeventMethods(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
QTclFileevent *e=(QTclFileevent *)clientData;
  if(argc<2) {
    Tcl_AppendElement(interp,"read");
    if(argc<1) return TCL_OK;
  } else if(!strcmp(argv[1],"read")) {
    return QTclFileeventRead(interp,e->objectName());
  }
  return QTclObjectMethods(clientData,interp,argc,argv);
}

int QTclFileeventInit(QTclInterp *qinterp) {
  QTclInterp::registerMethods("QFileevent",&QTclFileeventMethods);
  Tcl_CreateCommand(qinterp->interp(),"fileevent",QFileeventMethods,(ClientData)qinterp,0);
  return TCL_OK;
}

#include "moc_QTclFileevent.cpp"
