#ifndef __QTCLINTERP_H__
#define __QTCLINTERP_H__
extern "C" {
#include <tcl.h>
};

#include <QtCore/QObject>
#include "QTclFactory.h"

//struct Tcl_Interp;

class QTclInterp : public QObject {
  Q_OBJECT
  Q_PROPERTY( bool debug READ debug WRITE setDebug RESET unsetDebug )
  Q_PROPERTY( int interactive READ interactive WRITE setInteractive RESET unsetInteractive)
  Q_PROPERTY( QString result READ result DESIGNABLE false STORED false )
public:
  QTclInterp(QObject *parent);
  ~QTclInterp();
  int interactive() const { return _interactive; }
  bool debug() const { return _debug; }
  QString result() const;
  Tcl_Interp *interp() const { return _interp; }
public slots:
  void setDebug();
  void setDebug(bool debug);
  void unsetDebug();
  void setInteractive() { setInteractive(2); }
  void setInteractive(int interactive);
  void unsetInteractive();
  int  eval(const QString& cmd);
  int  evalFile(const QString& fileName);
private:
  bool _debug;
  int _interactive;
  Tcl_Interp *_interp;
public:
  static QString name(const QObject *w);
  static void registerObject(Tcl_Interp *interp,QObject *o,int deep=0);
  static int getObjectByName(Tcl_Interp *interp,const QString &name,QObject **result,const char* className=0);
  static int getWidgetByName(Tcl_Interp *interp,const QString &name,QWidget **result);
  static int prepareForCreate(Tcl_Interp *interp,const QString &name,const char* className,QObject **parent,QString &name);
  static void appendChildren(Tcl_Interp *interp,const QObject *w,int deepMode,const char *className);
  static void appendRootObjects(Tcl_Interp *interp);
  static void appendGlobalMethodNames(Tcl_Interp *interp);
  static void appendClassNames(Tcl_Interp *interp);
  static void appendClassMethodNames(Tcl_Interp *interp);
  static void appendName(Tcl_Interp *interp,const QObject *w);
  static int registerMethods(const char *className,Tcl_CmdProc *proc);
  static int registerClassMethods(const char *className,Tcl_CmdProc *proc);
  static int registerGlobalMethod(const char *factoryName,Tcl_CmdProc *proc);
  static int registerFactory(QTclFactory *factory);
  static Tcl_CmdProc *findMethods(const QObject *o);
  static Tcl_CmdProc *findClassMethods(const char *className);
  static Tcl_CmdProc *findClassMethods(const QObject *o);
  static Tcl_CmdProc *findGlobalMethod(const char *factoryName);
  /* GlobalFactory */
  static QObject *create(const char *className,QObject *parent,const QString &name);
  /* Evaluate */
  //static int eval(Tcl_Interp *interp,const QString &command,const QStringList& args);
  static int eval(Tcl_Interp *interp,const QString &command);
  static int eval(Tcl_Interp *interp,const QString &command,const QString& arg0);
  static int eval(Tcl_Interp *interp,const QString &command,const QString& arg0,const QString& arg1);
  static int eval(Tcl_Interp *interp,const QString &command,const QString& arg0,const QString& arg1,const QString& arg2);
  static int eval(Tcl_Interp *interp,const QString &command,const QString& arg0,const QString& arg1,const QString& arg2,const QString& arg3);
  static int eval(Tcl_Interp *interp,const QString &command,const QString& arg0,const QString& arg1,const QString& arg2,const QString& arg3,const QString& arg4);
  static int eval(Tcl_Interp *interp,const QString &command,const QString& arg0,const QString& arg1,const QString& arg2,const QString& arg3,const QString& arg4,const QString& arg5);
  static int eval(Tcl_Interp *interp,const QString &command,const QString& arg0,const QString& arg1,const QString& arg2,const QString& arg3,const QString& arg4,const QString& arg5,const QString& arg6);
};

#endif
