extern "C" {
#include <tcl.h>
}

#include <QStringListModel>
#include <QStandardItemModel>
#include <QDirModel>
#include <QTextStream>

#include "QTclObject.h"
#include "QTclUtil.h"
#include "QTclFactory.h"
#include "QTclInterp.h"

#include "QTclItemModel.h"

static int QTcl_GetModelIndex(Tcl_Interp *interp,const char *name,QAbstractItemModel *model,QModelIndex *result) {
int row=0;
int column=0;
QChar c0,c1,c2,c3;
QString n(name);
QTextStream s(&n);
QModelIndex parent;
  while(!s.atEnd()) {
    s >> c0 >> c1 >> row >>c2 >> column >>c3;
    if(c0=='.' && c1=='(' && c2==',' && c3==')') {
      parent=model->index(row,column,parent);
    } else {
      Tcl_AppendResult(interp,"wrong modelindex '",name,"'",0);
      return TCL_ERROR;
    }
  }
  *result=parent;
  return TCL_OK;
}

static QString QTcl_ModelIndexName(const QModelIndex& index) {
  if(!index.isValid()) return "";
  QString result=QTcl_ModelIndexName(index.parent());
  return result + ".(" + index.row() + "," + index.column() + ")";
}

static void QTclAppendModelIndex(Tcl_Interp *interp,const QModelIndex&index) {
  Tcl_AppendQString(interp,QTcl_ModelIndexName(index));
}

static int getOptions(Tcl_Interp *interp,int argc,char **argv,int *row,int *column,int *count,QModelIndex *parent,QAbstractItemModel *model,int rest) {
int i;
  for(i=2;i<argc-1;i+=2) {
    if(!strcmp(argv[i],"-row") && Tcl_GetInt(interp,argv[i+1],row)==TCL_OK) {
      continue;
    } else if(!strcmp(argv[i],"-column") && Tcl_GetInt(interp,argv[i+1],column)==TCL_OK) {
      continue;
    } else if(!strcmp(argv[i],"-count") && Tcl_GetInt(interp,argv[i+1],count)==TCL_OK) {
      continue;
    } else if(!strcmp(argv[i],"-parent") && QTcl_GetModelIndex(interp,argv[i+1],model,parent)==TCL_OK) {
      continue;
    }
    break;
  }
  if(argc-i==rest) return TCL_OK;
  return Tcl_WrongArgs(interp,argc,argv,"getOptions failed");
}

static int QTclStandardItemModelMethods(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
QStandardItemModel *w=(QStandardItemModel*)clientData;
int row=0;
int column=0;
int count=1;
QModelIndex parent;
  if(argc<2) {
    Tcl_AppendElement(interp,"columnCount");
    Tcl_AppendElement(interp,"rowCount");
    Tcl_AppendElement(interp,"insertRows");
    Tcl_AppendElement(interp,"insertColumns");
    Tcl_AppendElement(interp,"removeRows");
    Tcl_AppendElement(interp,"removeColumns");
    Tcl_AppendElement(interp,"setData");
    if(argc<1) return TCL_OK;
  } else if(argc==2 && !strcmp(argv[1],"columnCount")) {
    Tcl_AppendInt(interp,w->columnCount(parent));
    return TCL_OK;
  } else if(argc==2 && !strcmp(argv[1],"rowCount")) {
    Tcl_AppendInt(interp,w->rowCount(parent));
    return TCL_OK;
  } else if(!strcmp(argv[1],"insertRows")) {
    if(getOptions(interp,argc,argv,&row,&column,&count,&parent,w,0)!=TCL_OK) return TCL_ERROR;
    w->insertRows(row,count,parent);
    return TCL_OK;
  } else if(!strcmp(argv[1],"removeRows")) {
    if(getOptions(interp,argc,argv,&row,&column,&count,&parent,w,0)!=TCL_OK) return TCL_ERROR;
    w->removeRows(row,count,parent);
    return TCL_OK;
  } else if(!strcmp(argv[1],"insertColumns")) {
    if(getOptions(interp,argc,argv,&row,&column,&count,&parent,w,0)!=TCL_OK) return TCL_ERROR;
    w->insertColumns(column,count,parent);
    return TCL_OK;
  } else if(!strcmp(argv[1],"removeColumns")) {
    if(getOptions(interp,argc,argv,&row,&column,&count,&parent,w,0)!=TCL_OK) return TCL_ERROR;
    w->removeColumns(column,count);
    return TCL_OK;
  } else if(!strcmp(argv[1],"setData")) {
    if(getOptions(interp,argc,argv,&row,&column,&count,&parent,w,1)!=TCL_OK) return TCL_ERROR;
    w->setData(parent,QString(argv[argc-1]));
    return TCL_OK;
  } else if(!strcmp(argv[1],"data")) {
    if(getOptions(interp,argc,argv,&row,&column,&count,&parent,w,0)!=TCL_OK) return TCL_ERROR;
    Tcl_AppendQString(interp,w->data(parent).toString());
    return TCL_OK;
  }
  return QTclObjectMethods(clientData,interp,argc,argv);
}

class QTclItemModelFactory : public QTclFactory {
public:
  QTclItemModelFactory() {}
  virtual ~QTclItemModelFactory() {}
  virtual QObject *create(const QString& className,QObject *parentObject) {
    if(className=="QDirModel" )  { return new QDirModel(parentObject); }
    if(className=="QStandardItemModel" )  { return new QStandardItemModel(parentObject); }
    if(className=="QStringListModel" )  { return new QStringListModel(parentObject); }
    return 0;
  }
  virtual QStringList classNames() {
    QStringList result;
    const char *clNames[]= { "QDirModel","QStandardItemModel", "QStringListModel"};
    for(int i=0;i<QTCLARSIZE(clNames);i++) {
      result+=clNames[i];
    }
    return result;
  }
};

int QTclInitItemModel(QTclInterp * /*qinterp*/) {
  QTclInterp::registerMethods("QStandardItemModel",QTclStandardItemModelMethods);
  QTclInterp::registerFactory(new QTclItemModelFactory);
  return TCL_OK;
}

