extern "C" {
#include <tcl.h>
}

#include <QtGui>

#include "QTclObject.h"
#include "QTclWidget.h"
#include "QTclUtil.h"
#include "QTclFactory.h"
#include "QTclInterp.h"

#include "QTclLayout.h"

//------------------ Factory for Layouts --------------------------------

class QTclQtLayoutFactory: public QTclFactory {
public:
  virtual QLayout *create(const QString& className,QObject *parentObject) {
    if(parentObject && !((parentObject->inherits("QWidget")))) return 0; // TODO: Layout as Parent
    //if(parentObject && !((parentObject->inherits("QWidget")) || (parentObject->inherits("QLayout")))) return 0;
    QWidget *parent=(QWidget*)parentObject;
    if(className=="QGridLayout") return new QGridLayout(parent);
    if(className=="QVBoxLayout") return new QVBoxLayout(parent);
    if(className=="QHBoxLayout") return new QHBoxLayout(parent);
    return 0;
  }
  virtual QStringList classNames() {
    const char *clNames[]= { "QGridLayout", "QVBoxLayout", "QHBoxLayout" };
    return QTclCreateQStringList(QTCLARSIZE(clNames),clNames);
  }
};

static int QTclLayoutMethods(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
QLayout *l=(QLayout*)clientData;
  if(argc<2) {
    Tcl_AppendElement(interp,"invalidate");
    Tcl_AppendElement(interp,"add");
    Tcl_AppendElement(interp,"items");
    if(argc<1) return TCL_OK;
  } else if(!strcmp(argv[1],"invalidate")) {
    if(argc!=2) return Tcl_WrongArgs(interp,2,argv,0);
    l->invalidate();
    return TCL_OK;
  } else if(!strcmp(argv[1],"items")) {
    if(argc!=2) return Tcl_WrongArgs(interp,2,argv,0);
    for(int i=0;i<l->count();i++) {
      QLayoutItem *o=l->itemAt(i);
      QWidget* w;
      QLayout* l1;
      QSpacerItem* s;
      if((w=o->widget())) { 
        QTclInterp::appendName(interp,w);
      } else if((l1=o->layout())) {
        QTclInterp::appendName(interp,l1);
      } else if((s=o->spacerItem())) {
        Tcl_AppendElement(interp,"spacer");
      } else {
        Tcl_AppendElement(interp,"unknown");
      }
    }
    return TCL_OK;
  } else if(!strcmp(argv[1],"add")) {
    if(argc!=3) return Tcl_WrongArgs(interp,2,argv,"<widgetPath>");
    QWidget *w;
    if(QTclInterp::getWidgetByName(interp,argv[2],&w)!=TCL_OK) return TCL_ERROR;
    l->addWidget(w);
    return TCL_OK;
  }
  return QTclObjectMethods(clientData,interp,argc,argv);
}

static int parseArgs(Tcl_Interp *interp,int argc,char *argv[],int *at,int *stretch,Qt::Alignment *alignment,int *pos) {
  *at=-1;
  *stretch=0;
  *alignment=0;
  for(*pos=2;*pos<argc-1;*pos+=2) {
    if(!strcmp(argv[*pos],"-at")) {
      if(Tcl_GetInt(interp,argv[(*pos)+1],at)==TCL_ERROR) return TCL_ERROR;
    } else if(!strcmp(argv[*pos],"-stretch")) {
      if(Tcl_GetInt(interp,argv[(*pos)+1],stretch)==TCL_ERROR) return TCL_ERROR; 
    } else if(!strcmp(argv[*pos],"-alignment")) {
      int a;
      if(Tcl_GetInt(interp,argv[(*pos)+1],&a)==TCL_ERROR) return TCL_ERROR;
      *alignment=(Qt::Alignment)a;
    } else {
      break;
    }
  }
  return TCL_OK;
}

static int QTclBoxLayoutMethods(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
QBoxLayout*l=(QBoxLayout*)clientData;
  if(argc<2) {
    Tcl_AppendElement(interp,"insertWidget");
    Tcl_AppendElement(interp,"insertStretch");
    Tcl_AppendElement(interp,"insertSpacing");
    Tcl_AppendElement(interp,"setStretchFactor");
    if(argc<1) return TCL_OK;
  } else if(!strcmp(argv[1],"insertWidget")) {
    int at,stretch,pos;
    Qt::Alignment alignment;
    if(parseArgs(interp,argc,argv,&at,&stretch,&alignment,&pos)!=TCL_OK) return TCL_ERROR;
    if(pos!=argc-1) return Tcl_WrongArgs(interp,pos,argv,"<widgetPath>");
    QWidget *w;
    if(QTclInterp::getWidgetByName(interp,argv[pos],&w)!=TCL_OK) return TCL_ERROR;
    l->insertWidget(at,w,stretch,alignment);
    return TCL_OK;
  } else if(!strcmp(argv[1],"insertSpacing")) {
    int at,stretch,pos,size;
    Qt::Alignment alignment;
    if(parseArgs(interp,argc,argv,&at,&stretch,&alignment,&pos)!=TCL_OK) return TCL_ERROR;
    if(pos!=argc-1) return Tcl_WrongArgs(interp,pos,argv,"<size>");
    if(Tcl_GetInt(interp,argv[pos],&size)!=TCL_OK) return TCL_ERROR;
    l->insertSpacing(at,size);
    return TCL_OK;
  } else if(!strcmp(argv[1],"insertStretch")) {
    int at,stretch,pos;
    Qt::Alignment alignment;
    if(parseArgs(interp,argc,argv,&at,&stretch,&alignment,&pos)!=TCL_OK) return TCL_ERROR;
    if(pos!=argc) return Tcl_WrongArgs(interp,pos,argv,0);
    l->insertStretch(at,stretch);
    return TCL_OK;
  } else if(!strcmp(argv[1],"setStretchFactor")) {
    int at,stretch,pos;
    Qt::Alignment alignment;
    if(parseArgs(interp,argc,argv,&at,&stretch,&alignment,&pos)!=TCL_OK) return TCL_ERROR;
    if(pos!=argc-1) return Tcl_WrongArgs(interp,pos,argv,0);
    QWidget *w;
    if(QTclInterp::getWidgetByName(interp,argv[pos],&w)!=TCL_OK) return TCL_ERROR;
    l->setStretchFactor(w,stretch);
    return TCL_OK;
  }
  return QTclLayoutMethods(clientData,interp,argc,argv);
}
  
static int QTclGridLayoutMethods(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
QGridLayout *l=(QGridLayout*)clientData;
  if(argc<2) {
    Tcl_AppendElement(interp,"add");
    Tcl_AppendElement(interp,"rowstretch");
    Tcl_AppendElement(interp,"colstretch");
    Tcl_AppendElement(interp,"margin");
    Tcl_AppendElement(interp,"spacing");
    if(argc<1) return TCL_OK;
  } else if(!strcmp(argv[1],"add")) {
    for(int i=2;i<argc;) {
      QWidget *w;
      if(QTclInterp::getWidgetByName(interp,argv[i],&w)!=TCL_OK) return TCL_ERROR;
      int row=0;
      int column=0;
      int colspan=1;
      int rowspan=1;
      Qt::Alignment alignment=0;
      for(i++;i<argc-1;i++) {
        if(!strcmp(argv[i],"row")) {
          if(Tcl_GetInt(interp,argv[i+1],&row)!=TCL_OK) return TCL_ERROR;
        } else if(!strcmp(argv[i],"column")) {
          if(Tcl_GetInt(interp,argv[i+1],&column)!=TCL_OK) return TCL_ERROR;
        } else if(!strcmp(argv[i],"colspan")) {
          if(Tcl_GetInt(interp,argv[i+1],&colspan)!=TCL_OK) return TCL_ERROR;
        } else if(!strcmp(argv[i],"rowspan")) {
          if(Tcl_GetInt(interp,argv[i+1],&rowspan)!=TCL_OK) return TCL_ERROR;
        } else if(!strcmp(argv[i],"align")) {
          int a;
          if(Tcl_GetInt(interp,argv[i+1],&a)!=TCL_OK) return TCL_ERROR;
          alignment=(Qt::Alignment)a;
        }
      }
      l->addWidget(w,row,column,rowspan,colspan,alignment);
      return TCL_OK;
    }
    return TCL_OK;
  } else if(!strcmp(argv[1],"rowstretch")) {
    int row;
    switch(argc) {
      default:
      error:
        Tcl_WrongArgs(interp,2,argv,"<row> [<newValue>]");
        return TCL_ERROR;
      case 3:
        if(Tcl_GetInt(interp,argv[2],&row)!=TCL_OK) goto error;
        Tcl_AppendInt(interp,l->rowStretch(row));
        return TCL_OK;
      case 4:
        int value;
        if(Tcl_GetInt(interp,argv[2],&row)!=TCL_OK) goto error;
        if(Tcl_GetInt(interp,argv[3],&value)!=TCL_OK) goto error;
        l->setRowStretch(row,value);
        return TCL_OK;
    }
  } else if(!strcmp(argv[1],"colstretch")) {
    int col;
    switch(argc) {
      default:
      error1:
        Tcl_WrongArgs(interp,2,argv,"<col> [<newValue>]");
        return TCL_ERROR;
      case 3:
        if(Tcl_GetInt(interp,argv[2],&col)!=TCL_OK) goto error1;
        Tcl_AppendInt(interp,l->columnStretch(col));
        return TCL_OK;
      case 4:
        int value;
        if(Tcl_GetInt(interp,argv[2],&col)!=TCL_OK) goto error1;
        if(Tcl_GetInt(interp,argv[3],&value)!=TCL_OK) goto error1;
        l->setColumnStretch(col,value);
        return TCL_OK;
    }
  }
  return QTclLayoutMethods(clientData,interp,argc,argv);
}

int QTclInitLayout(QTclInterp * /*qinterp*/) {
  QTclInterp::registerMethods("QGridLayout",&QTclGridLayoutMethods);
  QTclInterp::registerMethods("QBoxLayout",&QTclBoxLayoutMethods);
  QTclInterp::registerMethods("QLayout",&QTclLayoutMethods);
  QTclInterp::registerFactory(new QTclQtLayoutFactory);
  return TCL_OK;
}

