extern "C" {
#include <tcl.h>
}

#include <QMessageBox>

#include "QTclObject.h"
#include "QTclUtil.h"
#include "QTclInterp.h"
#include "QTclWidget.h"

static struct {
  const char *name;
  int value;
} names[] = {
 { "Ok", QMessageBox::Ok },
 { "Cancel", QMessageBox::Cancel },
 { "Yes", QMessageBox::Yes },
 { "No", QMessageBox::No },
 { "Abort", QMessageBox::Abort },
 { "Retry", QMessageBox::Retry },
 { "Ignore", QMessageBox::Ignore },
 { "YesAll", QMessageBox::YesAll },
 { "NoAll", QMessageBox::NoAll },
 { "Default", QMessageBox::Default },
 { "Escape ", QMessageBox::Escape }
};

static int findKey(const char *key,int len) {
  for(int i=0;i<QTCLARSIZE(names);i++) {
    if(!strncmp(key,names[i].name,len)) return i;
  }
  return -1;
}

static int findValue(int value) {
  for(int i=0;i<QTCLARSIZE(names);i++) {
    if(names[i].value==value) return i;
  }
  return -1;
}

static int Tcl_GetButton(Tcl_Interp *interp,const char *keys,int *value) {
  *value=0;
  const char *key=keys;
  while(1) {
    char *next=strchr(key,'|');
    int len=next?next-key-1:strlen(key);
    int pos=findKey(key,len);
    if(pos<0) {
      int v;
      if(sscanf(key,"%i",&v)!=1) {
        Tcl_AppendResult(interp,"Wrong key:",keys,0);
        return TCL_ERROR;
      } else {
        *value|=v;
      }
    } else {
      *value|=names[pos].value;
    }
    if(!next) break;
    key=next+1;
  }
  return TCL_OK;
}

static void Tcl_AppendButton(Tcl_Interp *interp,int button) {
  int pos=findValue(button);
  if(pos<0) {
    Tcl_AppendInt(interp,button);
  } else {
    Tcl_AppendResult(interp,names[pos].name,0);
  }
}

static int QTclMessageBoxMethods(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
QMessageBox *w=(QMessageBox*)clientData;
  if(argc<2) {
    Tcl_AppendElement(interp,"buttonText");
    Tcl_AppendElement(interp,"setButtonText");
    if(argc<1) return TCL_OK;
  } else if(!strcmp(argv[1],"setButtonText")) {
    int nr;
    if(argc!=4 || Tcl_GetInt(interp,argv[2],&nr)!=TCL_OK || nr<0 || nr>10) {
      Tcl_AppendResult(interp,"expected: ",argv[0]," setButtonText nr text ",0);
      return TCL_ERROR;
    }
    w->setButtonText(nr,argv[3]);
    return TCL_OK;
  } else if(!strcmp(argv[1],"buttonText")) {
    int nr;
    if(argc!=3 || Tcl_GetInt(interp,argv[2],&nr)!=TCL_OK || nr<0 || nr>10) {
      Tcl_AppendResult(interp,"expected: ",argv[0]," buttonText nr",0);
      return TCL_ERROR;
    }
    Tcl_AppendResult(interp,QTclS2C(w->buttonText(nr)),0);
    return TCL_OK;
  }
  return QTclWidgetMethods(clientData,interp,argc,argv);
}

static int QTclMessageBoxClassMethods(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
QTclInterp *qinterp=(QTclInterp*)clientData;
QString text;
QWidget *parent=0;
QString caption;
int button0=0,button1=0,button2=0;
  if(argc<2) return Tcl_WrongArgs(qinterp->interp(),1,argv,"command options");
  for(int i=2;i+1<argc;i+=2) {
    if(!strcmp(argv[i],"text")) {
      text=argv[i+1];
    } else if(!strcmp(argv[i],"button0")) {
      if(Tcl_GetButton(interp,argv[i+1],&button0)!=TCL_OK) return TCL_ERROR;
    } else if(!strcmp(argv[i],"button1")) {
      if(Tcl_GetButton(interp,argv[i+1],&button1)!=TCL_OK) return TCL_ERROR;
    } else if(!strcmp(argv[i],"button2")) {
      if(Tcl_GetButton(interp,argv[i+1],&button2)!=TCL_OK) return TCL_ERROR;
    } else if(!strcmp(argv[i],"parent")) {
      if(QTclInterp::getWidgetByName(interp,argv[i+1],&parent)!=TCL_OK) return TCL_ERROR;
    } else if(!strcmp(argv[i],"caption")) {
      caption=argv[i+1];
    } else {
      return Tcl_WrongArgs(interp,1,argv,"options: [parent <widget>] [caption <caption>] [text <text> ] [button0 <button0>] [button1 <button1> ] [button2 <button2>]");
    }
  }
  if(!strcmp(argv[1],"critical")) {
    Tcl_AppendButton(interp,QMessageBox::critical(parent,caption,text,button0,button1,button2));
  } else if(!strcmp(argv[1],"question")) {
    Tcl_AppendButton(interp,QMessageBox::question(parent,caption,text,button0,button1,button2));
  } else if(!strcmp(argv[1],"warning")) {
    Tcl_AppendButton(interp,QMessageBox::warning(parent,caption,text,button0,button1,button2));
  } else if(!strcmp(argv[1],"information")) {
    Tcl_AppendButton(interp,QMessageBox::information(parent,caption,text,button0,button1,button2));
  } else if(!strcmp(argv[1],"about")) {
    QMessageBox::about(parent,caption,text);
    return TCL_OK;
  } else if(!strcmp(argv[1],"aboutQt")) {
    QMessageBox::aboutQt(parent,caption);
    return TCL_OK;
  } else {
    return Tcl_WrongArgs(interp,1,argv,"command: critical|question|warning|information|about|aboutQt");
  }
  return TCL_OK;
}

int QTclInitMessageBox(QTclInterp * /*qinterp*/) {
  QTclInterp::registerMethods("QMessageBox",&QTclMessageBoxMethods);
  QTclInterp::registerClassMethods("QMessageBox",&QTclMessageBoxClassMethods);
  return TCL_OK;
}

