#ifndef __QTCLPIXMAP_H__
#define __QTCLPIXMAP_H__


#include <QtCore/QObject>
#include <QtCore/QString>
#include <QtCore/QList>
#include <QtGui/QPixmap>

struct Tcl_Interp;
class QTclInterp;

class QTclPixmapFactory {
public:
  virtual ~QTclPixmapFactory() {}
  virtual QPixmap create(const QString &name)=0;
  virtual QStringList names()=0;
  virtual QString name(const QPixmap pixmap)=0;
};

int QTclInitPixmap(QTclInterp *qinterp);
int QTclGetPixmap(Tcl_Interp *interp,const QString &str,QPixmap *pp);
int QTclAppendPixmap(Tcl_Interp *interp,const QPixmap pixmap);
int QTclAppendPixmapPtr(Tcl_Interp *interp,const QPixmap *pixmapPtr);

#endif
