extern "C" {
#include <tcl.h>
#include <ctype.h>
}
#include <QList>

#include "QTclInterp.h"
#include "QTclUtil.h"

/* Modules to initialize */

#include "QTclWidget.h"
#include "QTclLayout.h"
#include "QTclObject.h"
#include "QTclAction.h"
#include "QTclValidator.h"
#include "QTclPixmap.h"
#include "QTclUI.h"
#include "QTclTimer.h"
#include "QTclFileevent.h"
#include "QTclXML.h"
#include "QTclItemModel.h"
#include "QTclApplication.h"

#include "QTclQt.h"

static int QTclQtCommand(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
QTclInterp *qinterp=(QTclInterp*)clientData;
Tcl_CmdProc *proc;
  if(argc<2) {
    Tcl_AppendElement(interp,"objects");
    Tcl_AppendElement(interp,"create");
    Tcl_AppendElement(interp,".<objectPath>");
    Tcl_AppendElement(interp,".<objectPath>*<objectName>");
    Tcl_AppendElement(interp,"*<objectName>");
    QTclInterp::appendGlobalMethodNames(interp);
    QTclInterp::appendClassMethodNames(interp);
    return TCL_OK;
  } else if((proc=QTclInterp::findGlobalMethod(argv[1]))) {
    return proc(clientData,interp,argc,argv);
  } else if(!strcmp(argv[1],"create")) {
    switch(argc) {
      case 3:
        return Tcl_WrongArgs(interp,2,argv,"<className> <name> [ <property> <value> ] .. ");
      case 2:
        QTclInterp::appendClassNames(interp);
        return TCL_OK;
    }
    QObject *parent;
    QString name;
    const char *path=argv[3];
    if(QTclInterp::prepareForCreate(interp,path,0,&parent,name)!=TCL_OK) {
      return TCL_ERROR;
    }
    QObject *w=QTclInterp::create(argv[2],parent,name);
    if(!w) {
      Tcl_AppendResult(interp,"error creating object '",argv[2],"' path '",path,"'",0);
      return TCL_ERROR;
    }
    QTclInterp::registerObject(interp,w);
    if(QTclSetProperties(interp,w,argc-4,argv+4)!=TCL_OK) {
      delete w;
      return TCL_ERROR;
    }
    QTclInterp::appendName(interp,w);
    return TCL_OK;
  } else if(!strcmp(argv[1],"objects") ) {
    QTclInterp::appendRootObjects(interp);
    return TCL_OK;
  } else if(isupper(argv[1][0])) {
    Tcl_CmdProc *proc=QTclInterp::findClassMethods(argv[1]);
    if(!proc) {
      Tcl_AppendResult(interp,"class methods for class:'",argv[1],"' not found",0);
      return TCL_ERROR;
    }
    return proc((ClientData)qinterp,interp,argc-1,argv+1);
#ifdef LATER
  } else if(argv[1][0]=='*') {
    const char *objectName=argv[1]+1;
    const QObjectList *cl=QObject::objectTrees();
    QObjectList l(*cl);
    if(cl) {
      for(QObject *p=l.first();p;p=l.next()) {
        QObject *w=p->child(objectName,0,TRUE);
        if(w) {
          Tcl_CmdProc *proc=QTclInterp::findMethods(w);
          return proc((ClientData)w,interp,argc-1,argv+1);
        }
      }
    }
    Tcl_AppendResult(interp,"object not found '",objectName,"'",0);
    return TCL_ERROR;
#endif
  } else if(argv[1][0]=='.') {
    const char *sptr=strchr(argv[1],'*');
    if(!sptr) {
      QObject *o;
      if(!strcmp(argv[1],".")) {
        o=qinterp;
      } else {
        if(QTclInterp::getObjectByName(interp,argv[1],&o)!=TCL_OK) return TCL_ERROR;
      }
      Tcl_CmdProc *proc=QTclInterp::findMethods(o);
      return proc((ClientData)o,interp,argc-1,argv+1);
    } else {
      int len=sptr-argv[1];
      Tcl_DString d;
      Tcl_DStringInit(&d);
      Tcl_DStringAppend(&d,argv[1],len);
      QObject *parent=0;
      const char *parentName=Tcl_DStringValue(&d);
      if(QTclInterp::getObjectByName(interp,parentName,&parent)!=TCL_OK) {
        Tcl_AppendResult(interp,"parent not found '",parentName,"'",0);
        return TCL_ERROR;
      }
      Tcl_DStringFree(&d);
      const char *childName=sptr+1;
      QObject *child=parent->findChild<QObject*>(QString(childName));
      if(!child) {
        Tcl_AppendResult(interp,"child not found '",childName,"'",0);
        return TCL_ERROR;
      }
      Tcl_CmdProc *proc=QTclInterp::findMethods(child);
      return proc((ClientData)child,interp,argc-1,argv+1);
    }
  }
  Tcl_WrongArgs(interp,1,argv," ");
  QTclQtCommand(clientData,interp,1,argv);
  return TCL_ERROR;
}

static void QTclQtExit(ClientData /*clientData*/) {
}

int QTclInitQt(QTclInterp *qinterp) {
  Tcl_CreateCommand(qinterp->interp(),"qt",QTclQtCommand,(ClientData)qinterp,QTclQtExit);
  QTclInitWidget(qinterp);
  //QTclInitCanvas(qinterp);
  QTclInitLayout(qinterp);
  QTclInitAction(qinterp);
  QTclInitPixmap(qinterp);
  QTclInitValidator(qinterp);
  QTclInitUI(qinterp);
  QTclObjectInit(qinterp);
  QTclTimerInit(qinterp);
  QTclFileeventInit(qinterp);
  QTclXMLInit(qinterp);
  QTclInitItemModel(qinterp);
  QTclInitApplication(qinterp);
  return TCL_OK;
}
