extern "C" {
#include <stdlib.h>
#include <tcl.h>
}

#include <QSizePolicy>

#include "QTclUtil.h"
#include "QTclInterp.h"

#include "QTclSizePolicy.h"

static const char *QTclSizePolicyToString(QSizePolicy::Policy value) {
  switch(value) {
    case QSizePolicy::Fixed:
      return "Fixed";
    case QSizePolicy::Minimum :
      return "Minimum";
    case QSizePolicy::Maximum:
      return "Maximum";
    case QSizePolicy::Preferred:
      return "Preferred";
    case QSizePolicy::Expanding:
      return "Expanding";
    case QSizePolicy::MinimumExpanding:
      return "MinimumExpanding";
    case QSizePolicy::Ignored:
      return "Ignored";
  }
  return "";
}

static int QTclSizePolicyFromString(Tcl_Interp *interp,const char *v,QSizePolicy::Policy *sPtr) {
  if(!strcmp(v,"Fixed"))                   { *sPtr=QSizePolicy::Fixed; return TCL_OK;
  } else if(!strcmp(v,"Minimum"))          { *sPtr= QSizePolicy::Minimum; return TCL_OK;
  } else if(!strcmp(v,"Maximum"))          { *sPtr= QSizePolicy::Maximum; return TCL_OK;
  } else if(!strcmp(v,"Preferred"))        { *sPtr= QSizePolicy::Preferred; return TCL_OK;
  } else if(!strcmp(v,"Expanding"))        { *sPtr= QSizePolicy::Expanding; return TCL_OK;
  } else if(!strcmp(v,"MinimumExpanding")) { *sPtr= QSizePolicy::MinimumExpanding; return TCL_OK;
  } else if(!strcmp(v,"Ignored"))          { *sPtr= QSizePolicy::Ignored; return TCL_OK;
  }
  Tcl_AppendResult(interp,"wrong Policy:",v," expecting: Fixed Minimum Maximum Prefered Expanding MinimumExpanding Ignored",0);
  return TCL_ERROR;
}

int QTclGetSizePolicy(Tcl_Interp *interp,const QString &value,QSizePolicy *s) { 
int largc;
char **largv;
QSizePolicy local;
int result=TCL_ERROR;
  if(Tcl_SplitList(interp,QTclS2C(value),&largc,&largv)!=TCL_OK) return TCL_ERROR;
  if(largc!=5) return Tcl_WrongArgs(interp,largc,largv,"wrong SizePolicy");
  while(1) {
    QSizePolicy::Policy hs=QSizePolicy::Preferred;
    QSizePolicy::Policy vs=QSizePolicy::Preferred;
    int hst=0;
    int vst=0;
    int hfw=false;
    if(Tcl_GetInt(interp,largv[0],(int*)&hs)!=TCL_OK && QTclSizePolicyFromString(interp,largv[0],&hs)!=TCL_OK) break; // Check 
    if(Tcl_GetInt(interp,largv[1],(int*)&vs)!=TCL_OK && QTclSizePolicyFromString(interp,largv[1],&vs)!=TCL_OK) break;
    if(Tcl_GetInt(interp,largv[2],&hst)!=TCL_OK) break;
    if(Tcl_GetInt(interp,largv[3],&vst)!=TCL_OK) break;
    if(Tcl_GetBoolean(interp,largv[4],&hfw)!=TCL_OK) break;
    s->setHorizontalPolicy(hs);
    s->setVerticalPolicy(vs);
    s->setHorizontalStretch(hst);
    s->setVerticalStretch(vst);
    s->setHeightForWidth(hfw);
    Tcl_ResetResult(interp);
    result=TCL_OK;
    break;
  }
  Tcl_Free((char*)largv);
  return result;
}

int QTclAppendSizePolicy(Tcl_Interp *interp,QSizePolicy s) {
  Tcl_AppendElement(interp,QTclSizePolicyToString(s.horizontalPolicy()));
  Tcl_AppendElement(interp,QTclSizePolicyToString(s.verticalPolicy()));
  Tcl_AppendInt(interp,s.horizontalStretch());
  Tcl_AppendInt(interp,s.verticalStretch());
  Tcl_AppendBool(interp,s.hasHeightForWidth());
  return TCL_OK;
}

int QTclSizePolicyInit(QTclInterp * /*qinterp*/) {
  return TCL_OK;
}

