extern "C" {
#include <string.h>
#include <tcl.h>
}

#include <QList>

#include "QTclTimer.h"
#include "QTclInterp.h"
#include "QTclUtil.h"


static const char *nextName() {
static char myName[50];
static int afterId=0;
  sprintf(myName,"after%d",afterId++);
  return myName;
}

QTclTimer::QTclTimer(QTclInterp *parent,const char *name,int time,const char *command):QTclCommand(parent,name?name:nextName(),parent->interp(),command) {
  qTimer=new QTimer(this);
  qTimer->setObjectName(name);
  connect(qTimer,SIGNAL(timeout()),this,SLOT(fire()));
  qTimer->setInterval(time<0?-time:time);
  qTimer->setSingleShot(time>=0);
  qTimer->start();
}

void QTclTimer::fire() {
  QTclInterp::eval(interp(),command(),objectName());
  if(_time>=0) delete this;
}

static int QTclAfterCmd(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
QTclInterp *qinterp=(QTclInterp*)clientData;
int value;
  switch(argc) {
    case 0:
      Tcl_AppendElement(interp,"info");
      Tcl_AppendElement(interp,"info <id>");
      Tcl_AppendElement(interp,"cancel <id>");
      Tcl_AppendElement(interp,"[-]<time> <cmd>");
      Tcl_AppendElement(interp,"<time>");
      return TCL_OK;
    case 1:
      break;
    case 2:
      if(!strcmp(argv[1],"info")) {
        QTclInterp::appendChildren(interp,qinterp,FALSE,"QTclTimer");
        return TCL_OK;
      }
      if(Tcl_GetInt(interp,argv[1],&value)!=TCL_OK) {
        //sleep(value/1000);
        return TCL_OK;
      }
      break;
    case 3:
      if(!strcmp(argv[1],"cancel")) {
        QObject *p;
        if(QTclInterp::getObjectByName(interp,argv[2],&p,"QTclTimer")!=TCL_OK) return TCL_ERROR;
        delete p;
        return TCL_OK;
      } else if(!strcmp(argv[1],"info")) {
        QObject *p;
        if(QTclInterp::getObjectByName(interp,argv[2],&p,"QTclTimer")!=TCL_OK) return TCL_ERROR;
        Tcl_AppendResult(interp,QTclS2C(((QTclTimer*)p)->command()),0);
        return TCL_OK;
      } 
      //NOBREAK
    default:
      if(!strcmp(argv[1],"idle")) {
        value=0;   
      } else if(Tcl_GetInt(interp,argv[1],&value)!=TCL_OK) {
        return TCL_ERROR;
      }
      Tcl_DString d;
      Tcl_DStringInit(&d);
      for(int i=2;i<argc;i++) {
        if(i!=2) Tcl_DStringAppend(&d," ",1);
        Tcl_DStringAppend(&d,argv[i],-1);
      }
      QTclTimer*t=new QTclTimer(qinterp,0,value,Tcl_DStringValue(&d));
      Tcl_DStringFree(&d);
      QTclInterp::appendName(interp,t);
      return TCL_OK;
  }
  Tcl_WrongArgs(interp,1,argv,0);
  QTclAfterCmd(clientData,interp,0,argv);
  return TCL_ERROR;
}

int QTclTimerInit(QTclInterp *qinterp) {
  Tcl_CreateCommand(qinterp->interp(),"after",QTclAfterCmd,(ClientData)qinterp,0);
  return TCL_OK;
}

#include "moc_QTclTimer.cpp"
