extern "C" {
#include <tcl.h>
}

#include <QBuffer>
#include <QFile>
#include <QWidget>
#include <QUiLoader>

#include "QTclInterp.h"
#include "QTclUtil.h"

#include "QTclUI.h"


static int UIload(Tcl_Interp *interp,const QString &fileName,QWidget *parent,const QString& name=QString()) {
QFile f(fileName);
  if(!f.open(QIODevice::ReadOnly)) {
    Tcl_AppendResult(interp,"Error opening ui file '",QTclS2C(fileName),"'",0);
    return TCL_ERROR;
  }
  QUiLoader *l=new QUiLoader(0);
  QWidget *w=l->load(&f,parent);
  delete l;
  f.close();
  if(!w) {
    Tcl_AppendResult(interp,"Error in Loading ui file '",QTclS2C(fileName),"'",0);
    return TCL_ERROR;
  }
  if(!name.isEmpty()) w->setObjectName(name);
  QTclInterp::registerObject(interp,w);
  QTclInterp::appendName(interp,w);
  return TCL_OK;
}

static int UIbuild(Tcl_Interp *interp,QByteArray &build,QWidget *parent,const QString& name=QString()) {
  QBuffer buffer(&build);
  buffer.open(QIODevice::ReadOnly);
  QUiLoader *l=new QUiLoader(0);
  QWidget *w=l->load(&buffer,parent);
  delete l;
  if(!w) {
    Tcl_AppendResult(interp,"Error building ui tree from '",build.data(),"'",0);
    return TCL_ERROR;
  }
  if(name.isEmpty()) w->setObjectName(name);
  QTclInterp::registerObject(interp,w);
  QTclInterp::appendName(interp,w);
  return TCL_OK;
}

static int QTclLoadCommand(ClientData /*clientData*/,Tcl_Interp *interp,int argc,char *argv[]) {
  switch(argc) {
    case 3:
      return UIload(interp,QString(argv[2]),0,0);
    case 4: {
      QWidget *parent;
      QString name;
      if(QTclInterp::prepareForCreate(interp,argv[3],"QWidget",(QObject**)&parent,name)!=TCL_OK) {
        return TCL_ERROR;
      }
      return UIload(interp,QString(argv[2]),parent,name);
    }
  }
  return Tcl_WrongArgs(interp,2,argv,"fileName [<objectPath>]");
}

static int QTclBuildCommand(ClientData /*clientData*/,Tcl_Interp *interp,int argc,char *argv[]) {
  switch(argc) {
    case 3: {
      QByteArray b(argv[2]);
      return UIbuild(interp,b,0,0);
      }
    case 4: {
      QByteArray b(argv[3]);
      QWidget *parent;
      QString name;
      if(QTclInterp::prepareForCreate(interp,argv[3],"QWidget",(QObject**)&parent,name)!=TCL_OK) {
        return TCL_ERROR;
      }
      return UIbuild(interp,b,parent,QString(name));
    }
  }
  return Tcl_WrongArgs(interp,2,argv,"string [<objectPath>]");
}

int QTclInitUI(QTclInterp * /*qinterp*/) {
  QTclInterp::registerGlobalMethod("load",QTclLoadCommand);
  QTclInterp::registerGlobalMethod("build",QTclBuildCommand);
  return TCL_OK;
}
