extern "C" {
#include <tcl.h>
}

#include "QTclUtil.h"

void Tcl_AppendInt(Tcl_Interp *interp,int val) {
char buffer[50];
  sprintf(buffer,"%d",val);
  Tcl_AppendElement(interp,buffer);
}

void Tcl_AppendBool(Tcl_Interp *interp,int val) {
char buffer[50];
  val=val?1:0;
  sprintf(buffer,"%d",val);
  Tcl_AppendElement(interp,buffer);
}

void Tcl_AppendBoolString(Tcl_Interp *interp,int val) {
  Tcl_AppendElement(interp,val?"true":"false");
}

void Tcl_AppendDouble(Tcl_Interp *interp,double val) {
char buffer[100];
  sprintf(buffer,"%.15g",val);
  Tcl_AppendElement(interp,buffer);
}

void Tcl_AppendIntAsHex(Tcl_Interp *interp,int val) {
char buffer[50];
  sprintf(buffer,"0x%8.8x",val);
  Tcl_AppendElement(interp,buffer);
}

void Tcl_AppendHexByte(Tcl_Interp *interp,int val) {
char buffer[50];
  sprintf(buffer,"%2.2x",(unsigned int)val);
  Tcl_AppendElement(interp,buffer);
}

void Tcl_AppendQString(Tcl_Interp *interp,const QString &s) {
  Tcl_AppendElement(interp,QTclS2C(s));
}

void Tcl_AppendQStringList(Tcl_Interp *interp,const QStringList &list) {
  for(QStringList::ConstIterator it=list.begin();it!=list.end();++it) {
    Tcl_AppendElement(interp,QTclS2C(*it));
  }
}

void Tcl_AppendArgcArgv(Tcl_Interp *interp,int argc,const char *argv[]) {
  for(int i=0;i<argc;i++) {
    Tcl_AppendElement(interp,argv[i]);
  }
}

void Tcl_AppendQByteArray(Tcl_Interp *interp,const QByteArray &a) {
  for(QByteArray::ConstIterator it=a.begin();it!=a.end();++it) {
    Tcl_AppendHexByte(interp,(*it));
  }
}

int Tcl_WrongArgs(Tcl_Interp *interp,int argc,char *argv[],const char *msg) {
  Tcl_AppendResult(interp,"wrong args: expected",0);
  for(int i=0;i<argc;i++) {
    Tcl_AppendResult(interp," ",argv[i],0);
  } 
  if(msg) {
    Tcl_AppendResult(interp," ",msg,0);
  }
  return TCL_ERROR;
}

void Tcl_DStringAppendSetInfo(Tcl_DString *d,const char *name,int value,QTclNameTable *t,int size) {
  Tcl_DStringStartSublist(d);
  Tcl_DStringAppendElement(d,name);
  Tcl_DStringStartSublist(d);
  for(int i=0;i<size;i++) {
    if(value&t[i].id) {
      Tcl_DStringStartSublist(d);
      Tcl_DStringAppendElement(d,t[i].name);
      Tcl_DStringEndSublist(d);
    }
  }
  Tcl_DStringEndSublist(d);
  Tcl_DStringEndSublist(d);
}

void Tcl_DStringAppendEnumInfo(Tcl_DString *d,const char *name,int value,QTclNameTable *t,int size) {
int found=0;
  Tcl_DStringStartSublist(d);
  Tcl_DStringAppendElement(d,name);
  for(int i=0;i<size;i++) {
    if(t[i].id==value) {
      Tcl_DStringAppendElement(d,t[i].name);
      found=1;
      break;
    }
  }
  if(!found) Tcl_DStringAppendElement(d,"");
  Tcl_DStringEndSublist(d);
}

void Tcl_DStringAppendStringInfo(Tcl_DString *d,const char *name,const char *value) {
  Tcl_DStringStartSublist(d);
  Tcl_DStringAppendElement(d,name);
  Tcl_DStringAppendElement(d,value);
  Tcl_DStringEndSublist(d);
}

void Tcl_DStringAppendQStringInfo(Tcl_DString *d,const char *name,const QString& value) {
  Tcl_DStringStartSublist(d);
  Tcl_DStringAppendElement(d,name);
  Tcl_DStringAppendElement(d,QTclS2C(value));
  Tcl_DStringEndSublist(d);
}

void Tcl_DStringAppendIntInfo(Tcl_DString *d,const char *name,int value) {
char buffer[100];
  sprintf(buffer,"%d",value);
  Tcl_DStringStartSublist(d);
  Tcl_DStringAppendElement(d,name);
  Tcl_DStringAppendElement(d,buffer);
  Tcl_DStringEndSublist(d);
}

void Tcl_DStringAppendBoolInfo(Tcl_DString *d,const char *name,int value) {
  Tcl_DStringStartSublist(d);
  Tcl_DStringAppendElement(d,name);
  Tcl_DStringAppendElement(d,value?"true":"false");
  Tcl_DStringEndSublist(d);
}

QStringList QTclCreateQStringList(int argc,const char *argv[]) {
QStringList result;
  for(int i=0;i<argc;i++) {
    result+=argv[i];
  }
  return result;
}

int Tcl_GetQStringList(Tcl_Interp *interp,const char *value,QStringList &result) {
int largc;
char **largv;
  if(Tcl_SplitList(interp,value,&largc,&largv)!=TCL_OK) return TCL_ERROR;
  for(int i=0;i<largc;i++) {
    result.append(QTclC2S(largv[i]));
  }
  Tcl_Free((char*)largv);
  return TCL_OK;
}
