#ifndef __QTCLUTIL_H__
#define __QTCLUTIL_H__

struct Tcl_Interp;
struct Tcl_DString;

#include <QtCore/QStringList>

void Tcl_AppendInt(Tcl_Interp *interp,int val);
void Tcl_AppendBool(Tcl_Interp *interp,int val);
void Tcl_AppendBoolString(Tcl_Interp *interp,int val);
void Tcl_AppendIntAsHex(Tcl_Interp *interp,int val);
void Tcl_AppendDouble(Tcl_Interp *interp,double val);
void Tcl_AppendHexByte(Tcl_Interp *interp,int val);
void Tcl_AppendQString(Tcl_Interp *interp,const QString &s);
void Tcl_AppendQStringList(Tcl_Interp *interp,const QStringList &list);
void Tcl_AppendQByteArray(Tcl_Interp *interp,const QByteArray &a);
void Tcl_AppendArgcArgv(Tcl_Interp *interp,int,const char *[]);

#define QTCLDECODING   toUtf8
#define QTCLENCODING   fromUtf8
#define QTCLARSIZE(a) ((int)(sizeof(a)/sizeof(a[0])))

#define QTclS2C(QStr) ((const char *)((QStr).QTCLDECODING()))
#define QTclC2S(S)    (QString().QTCLENCODING(S))

struct QTclName {
  const char *name;
};

struct QTclNameTable {
  const char *name;
  int id;
};


void Tcl_DStringAppendSetInfo(Tcl_DString *d,const char *name,int value,QTclNameTable *t,int size);
void Tcl_DStringAppendEnumInfo(Tcl_DString *d,const char *name,int value,QTclNameTable *t,int size);
void Tcl_DStringAppendStringInfo(Tcl_DString *d,const char *name,const char *value);
void Tcl_DStringAppendIntInfo(Tcl_DString *d,const char *name,int value);
void Tcl_DStringAppendBoolInfo(Tcl_DString *d,const char *name,int value);
void Tcl_DStringAppendQStringInfo(Tcl_DString *d,const char *name,const QString& value);

int Tcl_WrongArgs(Tcl_Interp *interp,int argc,char *argv[],const char *msg);

QStringList QTclCreateQStringList(int argc,const char *argv[]);
int Tcl_GetQStringList(Tcl_Interp *interp,const char *value,QStringList &result);

#endif
