extern "C" {
#include <tcl.h>
}
#include <QObject>
#include <QValidator>

#include "QTclInterp.h"
#include "QTclObject.h"
#include "QTclUtil.h"
#include "QTclFactory.h"

#include "QTclValidator.h"

//------------------ Factory for QValidators -------------------------------

class QTclQtValidatorFactory : public QTclFactory {
public:
  virtual QValidator *create(const QString& className,QObject *parent) {
    if(className=="QIntValidator") {
      return new QIntValidator(parent);
    } else if(className=="QDoubleValidator") {
      return new QDoubleValidator(parent);
    } else if(className=="QRegExpValidator") {
      return new QRegExpValidator(parent);
    }
    return 0;
  }
  virtual QStringList classNames() {
    const char *clNames[]= { "QIntValidator", "QDoubleValidator", "QRegExpValidator" };
    return QTclCreateQStringList(QTCLARSIZE(clNames),clNames);
  }
};

int QTclInitValidator(QTclInterp * /*qinterp*/) {
  QTclInterp::registerFactory(new QTclQtValidatorFactory);
  return TCL_OK;
}
