extern "C" {
#include <tcl.h>
}

#include <QtUiTools/QUiLoader>
#include <QFileDialog>
#include <QToolBar>
#include <QToolTip>
#include <QTabWidget>
#include <QListWidget>
#include <QComboBox>
#include <QMainWindow>
#include <QMessageBox>
#include <QStatusBar>
#include <QMenu>
#include <QTreeView>
#include <QMenuBar>
#include <QTextEdit>

#include "QTclObject.h"
#include "QTclUtil.h"
#include "QTclFactory.h"
#include "QTclInterp.h"
#include "QTclFileDialog.h"
#include "QTclFactory.h"
#include "QTclMessageBox.h"
#include "QTclWidget.h"

class QTclQtWidgetFactory : public QTclFactory {
public:
  QTclQtWidgetFactory() {
    loader=new QUiLoader();
  }
  virtual ~QTclQtWidgetFactory() {
    delete loader;
  }
  virtual QObject *create(const QString& className,QObject *parentObject) {
    if(parentObject && !(parentObject->inherits("QWidget"))) return 0;
    QWidget *parent=(QWidget*)parentObject; 
    if(className=="QMessageBox")      return new QMessageBox(parent);
    if(className=="QFileDialog")      return new QFileDialog(parent);
#ifdef LATER
    if(className=="QCanvasView")      return new QCanvasView(parent);
    if(className=="QHButtonGroup")    return new QHButtonGroup(parent);
    if(className=="QHGroupBox")       return new QHGroupBox(parent);
    if(className=="QHeader")          return new QHeader(parent);
    if(className=="QMenuBar")         return new QMenuBar(parent);
    if(className=="QProgressDialog")  return new QProgressDialog(parent);
    if(className=="QScrollView")      return new QScrollView(parent);
    if(className=="QSemiModal")       return new QSemiModal(parent);
    if(className=="QSizeGrip")        return new QSizeGrip(parent);
    if(className=="QSpinWidget")      return new QSpinWidget(parent);
    if(className=="QSplitter")        return new QSplitter(parent);
    if(className=="QStatusBar")       return new QStatusBar(parent);
    if(className=="QTabBar")          return new QTabBar(parent);
    if(className=="QTabDialog")       return new QTabDialog(parent);
    if(className=="QVButtonGroup")    return new QVButtonGroup(parent);
    if(className=="QVGroupBox")       return new QVGroupBox(parent);
    if(className=="QWorkspace")       return new QWorkspace(parent);
#endif
    if(className=="QToolBar" && parent->inherits("QMainWindow"))  { return new QToolBar(parent); }
    return loader->createWidget(className,parent);
  }
  virtual QStringList classNames() {
    QStringList result=loader->availableWidgets()
    ;
    const char *clNames[]= { "QFileDialog", "QHButtonGroup", "QHGroupBox", "QHeader",
    "QMenuBar", "QMessageBox", "QProgressDialog", "QScrollView", "QSemiModal", "QSizeGrip",
    "QSpinWidget", "QSplitter", "QStatusBar", "QTabBar", "QTabDialog", "QTclDOMTreeView",
    "QTclSpinListBox", "QToolBar", "QVButtonGroup", "QVGroupBox", "QWorkspace"
    };
    for(int i=0;i<QTCLARSIZE(clNames);i++) {
      result+=clNames[i];
    }
    return result;
  }
private:
  QUiLoader *loader;
};

int QTclWidgetMethods(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
QWidget *w=(QWidget*)clientData;
  if(argc<2) {
    Tcl_AppendElement(interp,"toplevel");
    Tcl_AppendElement(interp,"tooltip");
    Tcl_AppendElement(interp,"setTabOrder");
    Tcl_AppendElement(interp,"wflags");
    Tcl_AppendElement(interp,"display");
    if(argc<1) return TCL_OK;
  } else if(!strcmp(argv[1],"toplevel")) {
    if(argc!=2) return Tcl_WrongArgs(interp,2,argv,0);
    QWidget *t=w->topLevelWidget();
    if(t) QTclInterp::appendName(interp,t);
    return TCL_OK;
  } else if(!strcmp(argv[1],"setTabOrder")) {
    if(argc!=3) return Tcl_WrongArgs(interp,2,argv,"<widgetPath>");
    QWidget *next;
    if(QTclInterp::getWidgetByName(interp,argv[2],&next)!=TCL_OK) return TCL_ERROR;
    QWidget::setTabOrder(w,next);
    return TCL_OK;
  }
  return QTclObjectMethods(clientData,interp,argc,argv);
}

int QTclDialogMethods(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
QDialog *w=(QDialog*)clientData;
  if(argc<2) {
    Tcl_AppendElement(interp,"result");
    if(argc<1) return TCL_OK;
  } else if(argc==2 && !strcmp(argv[1],"result")) {
    Tcl_AppendInt(interp,w->result());
    return TCL_OK;
  }
  return QTclWidgetMethods(clientData,interp,argc,argv);
}

static int QTclTabWidgetMethods(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
QTabWidget *w=(QTabWidget*)clientData;
  if(argc<2) {
    Tcl_AppendElement(interp,"addTab");
    if(argc<1) return TCL_OK;
  } else if(argc>=4 && !strcmp(argv[1],"addTab")) {
    QWidget *child;
    if(QTclInterp::getWidgetByName(interp,argv[2],&child)!=TCL_OK) return TCL_ERROR;
    w->addTab(child,argv[3]);
    return TCL_OK;
  }
  return QTclWidgetMethods(clientData,interp,argc,argv);
}

static int QTclTreeWidgetMethods(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
//QListView *w=(QListView*)clientData;
  if(argc<2) {
    Tcl_AppendElement(interp,"tbd");
    if(argc<1) return TCL_OK;
#ifdef LATER
  } else if(argc==3 && !strcmp(argv[1],"addColumn")) {
    w->addColumn(QTclC2S(argv[2]));
    return TCL_OK;
#endif
  }
  return QTclWidgetMethods(clientData,interp,argc,argv);
}

static int QTclGetListIndexFromString(Tcl_Interp *interp,QObject *w,const char *string,int *result,int mode=0) {
  if(!(mode & 1)) {
    if(!strcmp(string,"end")) {
      *result=-1;
      return TCL_OK;
    }
  }
  if(!strcmp(string,"current")) {
    if(mode & 2) {
      *result=((QComboBox*)w)->currentIndex();
    } else {
      *result=((QListWidget*)w)->currentRow();
    }
    return TCL_OK;
  }
  if(Tcl_GetInt(interp,(char*)string,result)!=TCL_OK || *result<0 ) {
    Tcl_AppendResult(interp,"wrong listindex expected number or 'end'",0);
    return TCL_ERROR;
  }
  return TCL_OK;
}


static int QTclComboBoxMethods(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
QComboBox *w=(QComboBox*)clientData;
int index;
  if(argc<2) {
    Tcl_AppendElement(interp,"insertItems");
    Tcl_AppendElement(interp,"changeItem");
    Tcl_AppendElement(interp,"removeItem");
    Tcl_AppendElement(interp,"itemText");
    if(argc<1) return TCL_OK;
  } else if(argc>3 && !strcmp(argv[1],"insertItems")) {
    if(QTclGetListIndexFromString(interp,w,argv[2],&index,2)!=TCL_OK) return TCL_ERROR;
    w->insertItems(index,QTclCreateQStringList(argc-3,(const char **)(argv+3)));
    return TCL_OK;
  } else if(argc==4 && !strcmp(argv[1],"changeItem")) {
    if(QTclGetListIndexFromString(interp,w,argv[2],&index,3)!=TCL_OK) return TCL_ERROR;
    w->setItemText(index,QTclC2S(argv[3]));
    return TCL_OK;
  } else if(argc==3 && !strcmp(argv[1],"removeItem")) {
    if(QTclGetListIndexFromString(interp,w,argv[2],&index,3)!=TCL_OK) return TCL_ERROR;
    w->removeItem(index);
    return TCL_OK;
  } else if(argc==3 && !strcmp(argv[1],"itemText")) {
    if(QTclGetListIndexFromString(interp,w,argv[2],&index,2)!=TCL_OK) return TCL_ERROR;
    Tcl_AppendResult(interp,QTclS2C(w->itemText(index)),0);
    return TCL_OK;
  }
  return QTclWidgetMethods(clientData,interp,argc,argv);
}

static int QTclListWidgetMethods(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
QListWidget *w=(QListWidget*)clientData;
int index;
  if(argc<2) {
    Tcl_AppendElement(interp,"addItems");
    Tcl_AppendElement(interp,"insertItems");
    Tcl_AppendElement(interp,"removeItem");
    Tcl_AppendElement(interp,"clear");
    Tcl_AppendElement(interp,"itemText");
    if(argc<1) return TCL_OK;
  } else if(argc>3 && !strcmp(argv[1],"addItems")) {
    w->addItems(QTclCreateQStringList(argc-2,(const char **)(argv+2)));
    return TCL_OK;
  } else if(argc>3 && !strcmp(argv[1],"insertItems")) {
    if(QTclGetListIndexFromString(interp,w,argv[2],&index)!=TCL_OK) return TCL_ERROR;
    w->insertItems(index,QTclCreateQStringList(argc-3,(const char **)(argv+3))); 
    return TCL_OK;
  } else if(argc==3 && !strcmp(argv[1],"removeItem")) {
    if(QTclGetListIndexFromString(interp,w,argv[2],&index,1)!=TCL_OK) return TCL_ERROR;
    QListWidgetItem* i=w->takeItem(index);
    if(i) delete i;
    return TCL_OK;
  } else if(argc==2 && !strcmp(argv[1],"clear")) {
    w->clear();
    return TCL_OK;
  } else if(argc==3 && !strcmp(argv[1],"itemText")) {
    if(QTclGetListIndexFromString(interp,w,argv[2],&index)!=TCL_OK) return TCL_ERROR;
    QListWidgetItem* i=w->item(index);
    Tcl_AppendResult(interp,QTclS2C(i->text()),0);
    return TCL_OK;
  }
  return QTclWidgetMethods(clientData,interp,argc,argv);
}

static int QTclMainWindowMethods(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
QMainWindow *w=(QMainWindow*)clientData;
  if(argc<2) {
    Tcl_AppendElement(interp,"centralWidget");
    Tcl_AppendElement(interp,"setCentralWidget");
    Tcl_AppendElement(interp,"menuBar");
    Tcl_AppendElement(interp,"statusBar");
    if(argc<1) return TCL_OK;
  } else if(argc==2 && !strcmp(argv[1],"centralWidget")) {
    QTclInterp::appendName(interp,w->centralWidget());
    return TCL_OK;
  } else if(argc==3 && !strcmp(argv[1],"setCentralWidget")) {
    QWidget *t;
    if(QTclInterp::getWidgetByName(interp,argv[2],&t)!=TCL_OK) return TCL_ERROR;
    w->setCentralWidget(t);
    return TCL_OK;
  } else if(argc==2 && !strcmp(argv[1],"menuBar")) {
    QTclInterp::appendName(interp,w->menuBar());
    return TCL_OK;
  } else if(argc==2 && !strcmp(argv[1],"statusBar")) {
    QTclInterp::appendName(interp,w->statusBar());
    return TCL_OK;
  }
  return QTclWidgetMethods(clientData,interp,argc,argv);
}

static int QTclStatusBarMethods(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
QStatusBar *w=(QStatusBar*)clientData;
  if(argc<2) {
    Tcl_AppendElement(interp,"addWidget");
    Tcl_AppendElement(interp,"addPermanentWidget");
    Tcl_AppendElement(interp,"removeWidget");
    if(argc<1) return TCL_OK;
  } else if(argc==3 && !strcmp(argv[1],"addWidget")) {
    QWidget *t;
    if(QTclInterp::getWidgetByName(interp,argv[2],&t)!=TCL_OK) return TCL_ERROR;
    w->addWidget(t);
    return TCL_OK;
  } else if(argc==3 && !strcmp(argv[1],"addPermanentWidget")) {
    QWidget *t;
    if(QTclInterp::getWidgetByName(interp,argv[2],&t)!=TCL_OK) return TCL_ERROR;
    w->addPermanentWidget(t);
    return TCL_OK;
  } else if(argc==3 && !strcmp(argv[1],"removeWidget")) {
    QWidget *t;
    if(QTclInterp::getWidgetByName(interp,argv[2],&t)!=TCL_OK) return TCL_ERROR;
    w->removeWidget(t);
    return TCL_OK;
  }
  return QTclWidgetMethods(clientData,interp,argc,argv);
}

static int QTclMenuMethods(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
QMenu *w=(QMenu*)clientData;
  if(argc<2) {
    Tcl_AppendElement(interp,"exec");
    if(argc<1) return TCL_OK;
  } else if(!strcmp(argv[1],"exec")) {
    w->exec();
    return TCL_OK;
  }
  return QTclWidgetMethods(clientData,interp,argc,argv);
}

static int QTclTextEditMethods(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
QTextEdit *w=(QTextEdit*)clientData;
  if(argc<2) {
    Tcl_AppendElement(interp,"toPlainText");
    Tcl_AppendElement(interp,"document");
    if(argc<1) return TCL_OK;
  } else if(argc==2 && !strcmp(argv[1],"toPlainText")) {
    Tcl_AppendResult(interp,QTclS2C(w->toPlainText()),0);
    return TCL_OK;
  } else if(argc==2 && !strcmp(argv[1],"document")) {
    QTclInterp::appendName(interp,w->document());
    return TCL_OK;
  }
  return QTclWidgetMethods(clientData,interp,argc,argv);
}

static int QTclAbstractItemViewMethods(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
QAbstractItemView *w=(QAbstractItemView*)clientData;
  if(argc<2) {
    Tcl_AppendElement(interp,"model");
    Tcl_AppendElement(interp,"setModel");
    if(argc<1) return TCL_OK;
  } else if(!strcmp(argv[1],"model")) {
    QAbstractItemModel* m=w->model();
    if(m) QTclInterp::appendName(interp,m); else Tcl_AppendElement(interp,"");
    return TCL_OK;
  } else if(!strcmp(argv[1],"setModel")) {
    QAbstractItemModel* m;
    if(QTclInterp::getObjectByName(interp,argv[2],(QObject**)&m,"QAbstractItemModel")!=TCL_OK) return TCL_ERROR;
    w->setModel(m);
    return TCL_OK;
  }
  return QTclWidgetMethods(clientData,interp,argc,argv);
}

int QTclInitWidget(QTclInterp * qinterp) {
  QTclInterp::registerMethods("QWidget",&QTclWidgetMethods);
  QTclInterp::registerMethods("QDialog",&QTclDialogMethods);
  QTclInterp::registerMethods("QListWidget",&QTclListWidgetMethods);
  QTclInterp::registerMethods("QComboBox",&QTclComboBoxMethods);
  QTclInterp::registerMethods("QTreeWidget",&QTclTreeWidgetMethods);
  QTclInterp::registerMethods("QTabWidget",&QTclTabWidgetMethods);
  QTclInterp::registerMethods("QMainWindow",&QTclMainWindowMethods);
  QTclInterp::registerMethods("QStatusBar",&QTclStatusBarMethods);
  QTclInterp::registerMethods("QMenu",&QTclMenuMethods);
  QTclInterp::registerMethods("QTextEdit",&QTclTextEditMethods);
  QTclInterp::registerMethods("QAbstractItemView",&QTclAbstractItemViewMethods);
  QTclInterp::registerFactory(new QTclQtWidgetFactory);
  QTclInitFileDialog(qinterp);
  QTclInitMessageBox(qinterp);
  return TCL_OK;
}

