extern "C" {
#include <errno.h>
#include <string.h>
#include <tcl.h>
}

#include <QFile>
#include <QObject>
#include <QList>
#include <QMap>

#include "QTclObject.h"
#include "QTclUtil.h"
#include "QTclInterp.h"

#include "QTclXML.h"

QTclXMLDocument::QTclXMLDocument(QObject *parent) : QObject(parent) {
}

QTclXMLDocument::~QTclXMLDocument() {
}

void QTclXMLDocument::unsetDocument() {
  _document.clear();
  _filename="";
}

void QTclXMLDocument::setFilename(const QString&fname) {
  QFile f(fname);
  if(!f.open(QIODevice::ReadOnly) || !_document.setContent(&f)){
    unsetDocument();
  }
  if(f.isOpen()) f.close();
  _filename=fname;
}

const QString& QTclXMLDocument::filename() const {
  return _filename;
}

void QTclXMLDocument::setText(const QString &text) {
  _document.setContent(text);
  _filename="";
}

QString QTclXMLDocument::text() const {
  return _document.toString();
}

QDomDocument& QTclXMLDocument::document() {
  return _document;
}

static int getAttrList(const QDomElement &e,Tcl_DString *attrListPtr) {
QDomNamedNodeMap att=e.attributes();
  for(int i=0;i<(int)att.length();i++) {
    QDomAttr a=att.item(i).toAttr();
    Tcl_DStringStartSublist(attrListPtr);
    Tcl_DStringAppendElement(attrListPtr,QTclS2C(a.name()));
    Tcl_DStringAppendElement(attrListPtr,QTclS2C(a.value()));
    Tcl_DStringEndSublist(attrListPtr);
  }
  for(QDomNode n=e.firstChild();!n.isNull();n=n.nextSibling()) {
    if(n.isElement()) break;
    if(n.isCDATASection()) {
      Tcl_DStringStartSublist(attrListPtr);
      Tcl_DStringAppendElement(attrListPtr,"CDATA");
      Tcl_DStringAppendElement(attrListPtr,QTclS2C(n.nodeValue()));
      Tcl_DStringEndSublist(attrListPtr);
    }
    if(n.isText()) {
      Tcl_DStringStartSublist(attrListPtr);
      Tcl_DStringAppendElement(attrListPtr,"text");
      Tcl_DStringAppendElement(attrListPtr,QTclS2C(n.nodeValue()));
      Tcl_DStringEndSublist(attrListPtr);
    }
  }
  return TCL_OK;
}

static int traverseElements(Tcl_Interp *interp,const QDomElement &e) {
QString name=e.nodeName();
Tcl_DString attrList;
char buffer[0x1000];
  Tcl_DStringInit(&attrList);
  getAttrList(e,&attrList);
#ifndef _WIN32
  int len=snprintf(buffer,sizeof(buffer),"start %s %s",QTclS2C(name),Tcl_DStringValue(&attrList));
#else
  int len=sprintf(buffer,"start %s %s",QTclS2C(name),Tcl_DStringValue(&attrList));
#endif
  int result=Tcl_GlobalEval(interp,buffer);
  int dochilds=1;
  switch(result) {
    case TCL_ERROR:
    case TCL_CONTINUE:
    case TCL_RETURN:
      return TCL_ERROR;
    case TCL_BREAK:
      dochilds=0;
      break;
    case TCL_OK:
      break;
  }
  if(dochilds) {
    for(QDomNode n=e.firstChild();!n.isNull();n=n.nextSibling()) {
      if(!n.isElement()) continue;
      result=traverseElements(interp,n.toElement());  
      switch(result) {
        case TCL_ERROR:
        case TCL_CONTINUE:
        case TCL_RETURN:
          return TCL_ERROR;
          break;
        case TCL_OK:
        case TCL_BREAK:
          break;
      }
    } 
  }
#ifndef _WIN32
  len=snprintf(buffer,sizeof(buffer),"end %s %s",QTclS2C(name),Tcl_DStringValue(&attrList));
#else
  len=sprintf(buffer,"end %s %s",QTclS2C(name),Tcl_DStringValue(&attrList));
#endif
  result=Tcl_GlobalEval(interp,buffer);
  Tcl_DStringFree(&attrList);
  return result;
}

static int GetElementFromString(Tcl_Interp *interp,QDomDocument &doc,const char *tag,QDomNode &n) {
  if(!strcmp(tag,".")) {
    n= doc.documentElement();
  } else if(tag[0]=='#') {
    n= doc.elementById(tag+1);
  } else {
    QDomNodeList l=doc.elementsByTagName(tag);
    n=l.item(0);
  } 
  if(n.isNull()) {
    Tcl_AppendResult(interp,"invalid node '",tag,"'",0);
    return TCL_ERROR;
  }
  if(!n.isElement()) {
    Tcl_AppendResult(interp,"not a element '",tag,"'",0);
    return TCL_ERROR;
  }
  return TCL_OK;
}

static int QTclXMLDocumentCmd(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
QTclXMLDocument *doc=(QTclXMLDocument*)clientData;
  if(argc<2) {
    Tcl_AppendElement(interp,"traverse");
    if(argc<1) return TCL_OK;
  } else if(!strcmp(argv[1],"traverse")) {
    if(argc!=3) return Tcl_WrongArgs(interp,2,argv,"<element>");
    QDomNode n;
    if(GetElementFromString(interp,doc->document(),argv[2],n)!=TCL_OK) return TCL_OK;
    QDomElement e=n.toElement();
    return traverseElements(interp,e);
  }
  return QTclObjectMethods(clientData,interp,argc,argv);
}

class QTclQtDomFactory : public QTclFactory {
public:
  virtual QObject *create(const QString& className,QObject *parent) {
    if(className=="QTclXMLDocument") return new QTclXMLDocument(parent);
    return 0;
  }
  virtual QStringList classNames() {
    const char *clNames[]= { "QTclXMLDocument" };
    return QTclCreateQStringList(QTCLARSIZE(clNames),clNames);
  }
};

int QTclXMLInit(QTclInterp * /*qinterp*/) {
  QTclInterp::registerMethods("QTclXMLDocument",QTclXMLDocumentCmd);
  QTclInterp::registerFactory(new QTclQtDomFactory);
  return TCL_OK;
}

#include "moc_QTclXML.cpp"
