#ifndef __QTCLXML_H__
#define __QTCLXML_H__

#include <QtCore/QObject>
#include <QtCore/QString>
#include <QtXml/QDomDocument>

int QTclXMLInit(QTclInterp *qinterp);

class QTclXMLDocument :public QObject {
  Q_OBJECT
  Q_PROPERTY(QString text READ text WRITE setText DESIGNABLE false STORED false)
  Q_PROPERTY(QString filename READ filename WRITE setFilename DESIGNABLE false STORED false)
public:
  QTclXMLDocument(QObject *parent);
  ~QTclXMLDocument();
public slots:
  void setFilename(const QString&);
  void setText(const QString&);
  void unsetDocument();
public:
  const QString& filename() const;
  QString text() const;
  QDomDocument& document();
private:
  QDomDocument _document;
  QString _filename;
};

#endif
