extern "C" {
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#ifndef _WIN32
#include <getopt.h>
#include <unistd.h>
#else
#include "QTclWin32Compat.h"
#endif
}

#include <QApplication>

#include "QTclInterp.h"
#include "QTclUtil.h"

#define OPTIONS "vVic:dp"

static const char *version="0.9";
static const char *progname="";
static int verbose=0;
static int interactive=0;
static int pipemode=0;

int main(int argc,char *argv[]) {
int option;
int somethingdone=0;
QApplication app(argc,argv);
QTclInterp *qinterp=new QTclInterp(&app);
  qinterp->setObjectName("qinterp");
  QTclInterp::registerObject(qinterp->interp(),qinterp);
  QTclInterp::registerObject(qinterp->interp(),&app);
  progname=argv[0];
  while((option=getopt(argc,argv,OPTIONS))!=-1) {
    switch(option) {
      case 'i':
        interactive=1;
        break;
      case 'p':
        pipemode=1;
        break;
      case 'd':
        qinterp->setDebug(1);
        break;
      case 'v':
        verbose++; 
        break;
      case 'c':
        if(qinterp->eval(optarg)) {
          fprintf(stderr,"%s: %s\n",progname,QTclS2C(qinterp->result()));
          exit(1);
        }
        somethingdone=1;
        break;
      case 'V':
        printf("%s: version %s\n",progname,version);
        exit(0);
        break;
    }
  }
  argv+=optind;
  argc-=optind;
  for(int i=0;i<argc;i++) {
    if(qinterp->evalFile(argv[i])) {
      fprintf(stderr,"%s: %s\n",progname,QTclS2C(qinterp->result()));
      if(!interactive) exit(1);
    }
    somethingdone=1;
  }
  if(!somethingdone) interactive=1;
  if(pipemode) {
    qinterp->setInteractive(1);
  } else {
    if(interactive) {
      qinterp->setInteractive(isatty(0)?2:1);
    }
  }
  return app.exec();
}
