
#include "QTcl3D.h"
#define QTCLARSIZE(a) ((int)(sizeof(a)/sizeof(a[0])))

void Vertex::recalcNormal() {
  _normalCache.init();
  for(vector<Triangle*>::const_iterator i=usedBy.begin();i!=usedBy.end();++i) {
    _normalCache+=(*i)->normal();
  }
  _normalCache.normalize();
}

void World::makeDolphin(double x,double y,double z,double scale) {
  static double dolphinVectors[][3] = {
  {-3.994,15.39,1.382},
  {-4.9,15.52,0},
  {1.662,21.44,0},
  {2.957,21.22,1.037},
  {7.274,24.16,0},
  {7.837,23.64,0.6051},
  {12.63,24.55,0},
  {15.69,23.72,0},
  {12.72,13.75,1.685},
  {12.63,16.82,0},
  {14.44,12.59,0},
  {5.979,15.09,1.985},
  {10.34,20.7,0.6051},
  {-34.07,6.234,1.295},
  {-35.09,5.896,0},
  {-29.22,8.899,0},
  {-30.13,8.051,2.375},
  {-18.07,13.47,0},
  {-18.44,12.5,3.109},
  {-25.19,9.931,2.375},
  {-10.84,15.58,0},
  {-11.09,14.7,3.799},
  {-4.512,12.85,4.188},
  {5.376,12.59,4.533},
  {14.92,10.56,3.454},
  {23.04,10.06,1.985},
  {22.88,10.76,0},
  {28.95,10.39,0},
  {29.59,8.513,2.504},
  {32.77,10.76,0},
  {34.21,8.515,2.03},
  {36.53,11.5,0},
  {38.23,9.715,1.338},
  {39.65,12.3,0},
  {40.9,11.42,1.64},
  {42.75,12.03,0},
  {42.19,11.17,1.253},
  {-25.87,9.001,3.799},
  {-23.33,8.093,5.57},
  {-17.92,9.949,5.094},
  {-25.76,6.465,6.218},
  {-27.34,7.173,5.397},
  {-28.9,6.369,4.663},
  {-25.83,4.737,6.087},
  {-27.42,5.94,5.268},
  {-36.2,1.755,2.375},
  {-42.17,-1.625,1.253},
  {-43.23,-1.921,0.6901},
  {-43.35,-1.599,0},
  {-37.49,1.971,0},
  {-36.9,2.177,0.8635},
  {-28.1,5.103,5.224},
  {-29.65,3.666,5.224},
  {-32.1,3.598,4.491},
  {-31.83,2.565,4.404},
  {-35.16,-1.002,2.764},
  {-40.44,-2.856,1.424},
  {-31.29,0.4554,4.404},
  {-29.04,2.497,5.871},
  {-25.57,0.1562,5.915},
  {-31.14,-0.5792,4.663},
  {-27.95,3.128,5.915},
  {-27.19,4.529,5.871},
  {-35.19,-1.904,3.109},
  {-39.96,-3.533,1.856},
  {-31.54,-4.292,2.893},
  {-24.89,-4.433,3.799},
  {-34.62,-3.494,1.727},
  {-35.3,-2.506,2.936},
  {-19.06,-2.042,7.34},
  {-19.12,-3.752,5.958},
  {-24.63,2.144,6.866},
  {-17.45,2.874,8.377},
  {-17.18,6.919,7.253},
  {-11.74,7.545,7.858},
  {-10.44,2.999,8.678},
  {-3.735,4.426,8.161},
  {4.771,1.273,8.333},
  {13.92,4.253,7.469},
  {13.84,-0.323,7.598},
  {23.64,5.182,5.613},
  {24.2,1.047,4.836},
  {30.05,5.892,3.972},
  {31.31,1.896,3.712},
  {34.92,6.51,2.375},
  {38.21,7.81,1.685},
  {38.96,5.746,1.814},
  {41.57,10.29,3.109},
  {-12.1,-2.376,6.995},
  {-2.612,-4.556,6.39},
  {12.02,-4.641,5.268},
  {24.23,-2.58,2.936},
  {32.85,-0.7725,1.64},
  {41.56,5.674,0.9502},
  {43.37,7.643,2.03},
  {-14.71,-2.846,12.52},
  {-14.92,-3.132,12.13},
  {-10.5,-2.154,10.97},
  {-6.601,-4.307,13.13},
  {-9.23,-4.347,13.73},
  {-12.82,-3.608,13.6},
  {-3.217,-6.799,0},
  {-12.12,-5.088,0},
  {11.64,-6.498,0},
  {25.35,-2.875,0},
  {36.97,1.364,0},
  {41.93,5.626,0},
  {-17.76,-5.219,0},
  {-30.31,-5.143,0},
  {-34.25,-3.973,0},
  {-39.26,-4.556,0},
  {-39.71,-4.171,1.338},
  {-43,-4.687,0},
  {-42.47,-4.471,0.7768},
  {46.12,13.36,1.64},
  {43.95,11.45,2.806},
  {44.85,12.53,0},
  {47.26,14.97,0.9927},
  {46.37,13.64,0},
  {42.01,10.01,4.102},
  {-43.14,-2.925,0.6476},
  {-43.21,-2.853,0},
  {-43.16,-3.842,0.821},
  {-43.52,-3.849,0},
  {-9.214,-4.492,13.47},
  {-12.8,-3.928,13.3},
  {14.23,20.36,0},
  {16.21,22.34,0},
  {32.52,-1.316,0},
  {43.84,7.763,0},
  {47.88,11.11,12.43},
  {45.28,9.092,8.893},
  {44.71,9.572,8.893},
  {48.41,15.29,3.67},
  {2.957,21.22,-1.037},
  {-3.994,15.39,-1.382},
  {7.837,23.64,-0.6051},
  {12.93,23.81,-0.2159},
  {12.72,13.75,-1.685},
  {8.527,18.72,-1.037},
  {5.979,15.09,-1.985},
  {-34.07,6.234,-1.295},
  {-30.13,8.051,-2.375},
  {-25.19,9.931,-2.375},
  {-18.44,12.5,-3.109},
  {-11.09,14.7,-3.799},
  {-4.512,12.85,-4.188},
  {5.376,12.59,-4.533},
  {14.92,10.56,-3.454},
  {23.04,10.06,-1.985},
  {29.59,8.513,-2.504},
  {34.21,8.515,-2.03},
  {38.23,9.715,-1.338},
  {40.9,11.42,-1.64},
  {42.19,11.17,-1.253},
  {-25.87,9.001,-3.799},
  {-23.33,8.093,-5.57},
  {-4.512,9.823,-6.087},
  {-27.34,7.173,-5.397},
  {-25.76,6.465,-6.218},
  {-28.9,6.369,-4.663},
  {-32.39,4.414,-3.541},
  {-35.48,2.88,-1.727},
  {-27.42,5.94,-5.268},
  {-25.83,4.737,-6.087},
  {-36.2,1.755,-2.375},
  {-42.17,-1.625,-1.253},
  {-41.46,-2.305,-1.253},
  {-36.9,2.177,-0.8635},
  {-43.23,-1.921,-0.6901},
  {-29.69,4.172,-5.181},
  {-32.1,3.598,-4.491},
  {-31.83,2.565,-4.404},
  {-40.44,-2.856,-1.424},
  {-31.29,0.4554,-4.404},
  {-29.04,2.497,-5.871},
  {-31.14,-0.5792,-4.663},
  {-25.57,0.1562,-5.915},
  {-27.95,3.128,-5.915},
  {-27.19,4.529,-5.871},
  {-39.96,-3.533,-1.856},
  {-31.54,-4.292,-2.893},
  {-24.89,-4.433,-3.799},
  {-35.3,-2.506,-2.936},
  {-34.62,-3.494,-1.727},
  {-19.12,-3.752,-5.958},
  {-19.06,-2.042,-7.34},
  {-17.45,2.874,-8.377},
  {-24.63,2.144,-6.866},
  {-17.18,6.919,-7.253},
  {-10.44,2.999,-8.678},
  {-11.74,7.545,-7.858},
  {-3.735,4.426,-8.161},
  {4.771,1.273,-8.333},
  {4.425,5.29,-7.858},
  {13.84,-0.323,-7.598},
  {13.92,4.253,-7.469},
  {24.2,1.047,-4.836},
  {23.64,5.182,-5.613},
  {31.31,1.896,-3.712},
  {30.05,5.892,-3.972},
  {35.98,4.138,-2.417},
  {34.92,6.51,-2.375},
  {38.96,5.746,-1.814},
  {38.21,7.81,-1.685},
  {41.57,10.29,-3.109},
  {-12.1,-2.376,-6.995},
  {-2.612,-4.556,-6.39},
  {12.02,-4.641,-5.268},
  {24.23,-2.58,-2.936},
  {32.85,-0.7725,-1.64},
  {36.87,2.134,-1.209},
  {41.56,5.674,-0.9502},
  {43.37,7.643,-2.03},
  {-14.92,-3.132,-12.13},
  {-14.71,-2.846,-12.52},
  {-10.5,-2.154,-10.97},
  {-6.601,-4.307,-13.13},
  {-12.82,-3.608,-13.6},
  {-9.23,-4.347,-13.73},
  {-39.71,-4.171,-1.338},
  {-42.47,-4.471,-0.7768},
  {49.69,15.85,-10.75},
  {47.52,11.34,-12.43},
  {50.8,17.17,-14.72},
  {43.95,11.45,-2.806},
  {46.12,13.36,-1.64},
  {47.26,14.97,-0.9927},
  {42.01,10.01,-4.102},
  {-43.14,-2.925,-0.6476},
  {-43.16,-3.842,-0.821},
  {-12.8,-3.928,-13.3},
  {-9.214,-4.492,-13.47},
  {44.71,9.572,-8.893},
  {45.28,9.092,-8.893},
  {47.88,11.11,-12.43},
  {48.41,15.29,-3.67}
  };
  static int dolphinTriangles[][3] = {
  {2,1,0},
  {0,3,2},
    {4,2,3},
    {3,5,4},
    {6,4,5},
    {7,6,5},
    {10,9,8},
    {3,0,11},
    {5,3,11},
    {11,12,5},
    {14,13,15},
    {13,16,15},
    {19,18,17},
    {20,17,18},
    {18,21,20},
    {1,20,21},
    {21,0,1},
    {22,0,21},
    {11,0,22},
    {22,23,11},
    {8,11,23},
    {23,24,8},
    {10,8,24},
    {10,24,25},
    {25,26,10},
    {27,26,25},
    {25,28,27},
    {29,27,28},
    {28,30,29},
    {31,29,30},
    {30,32,31},
    {33,31,32},
    {32,34,33},
    {35,33,34},
    {34,36,35},
    {19,16,37},
    {19,37,38},
    {19,38,39},
    {39,18,19},
    {21,18,39},
    {22,76,23},
    {24,23,76},
    {41,40,38},
    {38,37,41},
    {42,41,37},
    {37,16,42},
    {53,42,16},
    {16,13,53},
    {44,43,40},
    {40,41,44},
    {42,44,41},
    {49,48,47},
    {47,50,49},
    {50,53,13},
    {13,14,50},
    {49,50,14},
    {51,42,52},
    {53,52,42},
    {53,54,52},
    {54,53,45},
    {55,45,46},
    {46,56,55},
    {54,45,55},
    {55,57,54},
    {58,52,54},
    {59,58,57},
    {57,60,59},
    {45,53,50},
    {51,52,61},
    {62,51,61},
    {43,62,61},
    {71,43,61},
    {58,71,61},
    {52,58,61},
    {56,64,63},
    {63,55,56},
    {55,63,60},
    {60,57,55},
    {65,59,60},
    {59,65,66},
    {67,65,60},
    {60,68,67},
    {69,59,66},
    {66,70,69},
    {71,59,69},
    {69,72,71},
    {71,73,43},
    {38,40,43},
    {38,43,73},
    {71,72,73},
    {74,73,72},
    {72,75,74},
    {76,74,75},
    {75,77,76},
    {78,76,77},
    {77,79,78},
    {80,78,79},
    {79,81,80},
    {82,80,81},
    {81,83,82},
    {84,82,83},
    {83,86,84},
    {85,84,86},
    {39,38,73},
    {21,39,73},
    {73,74,21},
    {22,21,74},
    {74,76,22},
    {76,78,24},
    {25,24,78},
    {78,80,25},
    {28,25,80},
    {80,82,28},
    {30,28,82},
    {82,84,30},
    {32,30,84},
    {84,85,32},
    {34,32,85},
    {85,87,34},
    {36,34,87},
    {75,72,69},
    {69,88,75},
    {77,75,88},
    {88,89,77},
    {79,77,89},
    {89,90,79},
    {81,79,90},
    {90,91,81},
    {83,81,91},
    {91,92,83},
    {86,83,92},
    {92,93,86},
    {94,86,93},
    {95,69,70},
    {70,96,95},
    {88,69,95},
    {95,97,88},
    {98,97,95},
    {95,99,98},
    {99,95,100},
    {101,89,88},
    {88,102,101},
    {91,90,103},
    {103,104,91},
    {93,92,105},
    {105,106,93},
    {70,66,107},
    {88,70,107},
    {107,102,88},
    {66,65,108},
    {108,107,66},
    {65,67,109},
    {109,108,65},
    {67,111,110},
    {110,109,67},
    {67,68,111},
    {113,112,110},
    {110,111,113},
    {36,115,114},
    {114,116,36},
    {116,114,117},
    {117,118,116},
    {119,87,85},
    {85,86,119},
    {94,119,86},
    {46,45,50},
    {50,47,46},
    {121,120,47},
    {47,48,121},
    {46,47,120},
    {60,63,68},
    {64,111,68},
    {68,63,64},
    {111,64,113},
    {122,113,64},
    {64,56,122},
    {120,122,56},
    {56,46,120},
    {112,113,122},
    {122,123,112},
    {120,121,123},
    {123,122,120},
    {44,42,51},
    {62,43,44},
    {59,71,58},
    {51,62,44},
    {125,124,99},
    {99,100,125},
    {100,95,96},
    {96,125,100},
    {98,99,124},
    {97,96,70},
    {70,88,97},
    {98,124,125},
    {125,97,98},
    {97,125,96},
    {11,8,9},
    {9,126,12},
    {12,11,9},
    {126,127,7},
    {7,12,126},
    {12,7,5},
    {90,89,103},
    {89,101,103},
    {92,128,105},
    {104,128,92},
    {92,91,104},
    {93,106,129},
    {129,94,93},
    {130,132,131},
    {132,119,94},
    {94,131,132},
    {36,116,35},
    {94,129,118},
    {118,117,133},
    {133,94,118},
    {94,133,131},
    {130,131,133},
    {133,132,130},
    {133,117,114},
    {114,132,133},
    {132,114,115},
    {132,115,119},
    {115,36,87},
    {87,119,115},
    {16,19,17},
    {17,15,16},
    {1,2,134},
    {134,135,1},
    {2,4,136},
    {136,134,2},
    {4,6,137},
    {137,136,4},
    {137,6,7},
    {138,9,10},
    {135,134,139},
    {139,140,135},
    {136,139,134},
    {15,141,14},
    {142,141,15},
    {143,17,144},
    {17,20,145},
    {145,144,17},
    {20,1,135},
    {135,145,20},
    {145,135,146},
    {135,140,147},
    {147,146,135},
    {140,138,148},
    {148,147,140},
    {148,138,10},
    {148,10,26},
    {26,149,148},
    {26,27,150},
    {150,149,26},
    {27,29,151},
    {151,150,27},
    {29,31,152},
    {152,151,29},
    {31,33,153},
    {153,152,31},
    {33,35,154},
    {154,153,33},
    {155,142,143},
    {156,155,143},
    {156,143,144},
    {145,146,157},
    {147,157,146},
    {159,158,155},
    {155,156,159},
    {158,160,142},
    {142,155,158},
    {142,160,161},
    {161,141,142},
    {141,161,162},
    {164,163,158},
    {158,159,164},
    {158,163,160},
    {161,165,162},
    {167,166,165},
    {48,49,168},
    {168,169,48},
    {162,168,14},
    {14,141,162},
    {14,168,49},
    {160,178,170},
    {161,160,170},
    {170,171,161},
    {172,171,170},
    {171,172,165},
    {165,183,173},
    {173,167,165},
    {165,172,174},
    {174,183,165},
    {172,170,175},
    {175,177,176},
    {176,174,175},
    {168,162,165},
    {178,179,164},
    {178,164,188},
    {178,188,175},
    {178,175,170},
    {180,173,183},
    {174,176,183},
    {176,182,181},
    {182,176,177},
    {181,184,183},
    {183,176,181},
    {177,186,185},
    {185,182,177},
    {177,188,187},
    {187,186,177},
    {164,159,156},
    {164,189,187},
    {187,188,164},
    {189,191,190},
    {190,187,189},
    {191,192,190},
    {192,194,193},
    {193,190,192},
    {194,196,195},
    {195,193,194},
    {196,198,197},
    {197,195,196},
    {198,200,199},
    {199,197,198},
    {200,202,201},
    {201,199,200},
    {202,204,203},
    {203,201,202},
    {189,164,156},
    {189,156,144},
    {144,145,191},
    {191,189,144},
    {145,157,192},
    {192,191,145},
    {157,147,194},
    {194,192,157},
    {147,148,196},
    {196,194,147},
    {148,149,198},
    {198,196,148},
    {149,150,200},
    {200,198,149},
    {150,151,202},
    {202,200,150},
    {151,152,204},
    {204,202,151},
    {152,153,205},
    {205,204,152},
    {205,153,154},
    {187,190,206},
    {206,186,187},
    {207,206,190},
    {190,193,207},
    {193,195,208},
    {208,207,193},
    {195,197,209},
    {209,208,195},
    {197,199,210},
    {210,209,197},
    {199,201,211},
    {211,210,199},
    {201,203,212},
    {212,211,201},
    {212,203,213},
    {186,215,214},
    {214,185,186},
    {186,206,216},
    {216,215,186},
    {215,216,217},
    {217,218,215},
    {218,217,219},
    {207,101,102},
    {102,206,207},
    {208,209,104},
    {104,103,208},
    {211,212,106},
    {106,105,211},
    {182,185,107},
    {185,206,102},
    {102,107,185},
    {181,182,107},
    {107,108,181},
    {184,181,108},
    {108,109,184},
    {220,184,109},
    {109,110,220},
    {220,183,184},
    {112,221,220},
    {220,110,112},
    {224,223,222},
    {225,154,116},
    {116,226,225},
    {226,116,118},
    {118,227,226},
    {205,228,203},
    {203,204,205},
    {203,228,213},
    {165,166,169},
    {169,168,165},
    {229,121,48},
    {48,169,229},
    {169,166,167},
    {167,229,169},
    {220,180,183},
    {221,180,220},
    {221,230,173},
    {173,180,221},
    {230,229,167},
    {167,173,230},
    {221,112,123},
    {123,230,221},
    {121,229,230},
    {230,123,121},
    {178,160,163},
    {163,164,179},
    {175,188,177},
    {161,171,165},
    {163,179,178},
    {232,231,218},
    {218,219,232},
    {215,218,231},
    {231,214,215},
    {232,219,217},
    {214,216,206},
    {206,185,214},
    {231,232,217},
    {217,214,231},
    {214,217,216},
    {139,9,138},
    {138,140,139},
    {126,9,139},
    {139,136,126},
    {126,137,7},
    {137,126,136},
    {207,208,103},
    {207,103,101},
    {211,105,128},
    {128,210,211},
    {128,104,209},
    {209,210,128},
    {106,212,213},
    {213,129,106},
    {235,234,233},
    {233,223,235},
    {228,233,234},
    {234,213,228},
    {235,223,224},
    {35,116,154},
    {118,129,213},
    {236,227,118},
    {118,234,236},
    {234,118,213},
    {222,236,234},
    {234,235,222},
    {224,222,235},
    {222,223,233},
    {233,236,222},
    {227,236,233},
    {233,226,227},
    {225,226,233},
    {228,225,233},
    {154,225,228},
    {228,205,154},
    {17,142,15},
    {17,143,142},
    {175,174,172},
    {54,57,58}
  };
  for(int i=0;i<QTCLARSIZE(dolphinVectors);i++) {
    addVertex(
      scale*dolphinVectors[i][0]+x,
      scale*dolphinVectors[i][1]+y,
      scale*dolphinVectors[i][2]+z);
  }
  for(int i=0;i<QTCLARSIZE(dolphinTriangles);i++) {
    addTriangle(
      dolphinTriangles[i][0],
      dolphinTriangles[i][1],
      dolphinTriangles[i][2]);
  }
}

void World::makeCubus(double x,double y,double z,double scale) {
  static double cubusVectors[][3] = {
    { -1.0, -1.0, -1.0 },
    { +1.0, -1.0, -1.0 },
    { +1.0, +1.0, -1.0 },
    { -1.0, +1.0, -1.0 },
    { -1.0, -1.0, +1.0 },
    { +1.0, -1.0, +1.0 },
    { +1.0, +1.0, +1.0 },
    { -1.0, +1.0, +1.0 }
  };
  static unsigned int cubusTriangles[][3] = {
     { 0,4,5 },
     { 1,3,0 },
     { 2,1,6 },
     { 3,2,6 },
     { 4,7,5 },
     { 5,1,0 },
     { 6,1,5 },
     { 7,3,6 },
     { 2,3,1 },
     { 3,7,0 },
     { 0,7,4 },
     { 5,7,6 }
  };
  for(int i=0;i<QTCLARSIZE(cubusVectors);i++) {
    addVertex(
      scale*cubusVectors[i][0]+x,
      scale*cubusVectors[i][1]+y,
      scale*cubusVectors[i][2]+z
   );
  }
  for(int i=0;i<QTCLARSIZE(cubusTriangles);i++) {
    addTriangle(
      cubusTriangles[i][0],
      cubusTriangles[i][1],
      cubusTriangles[i][2]);
  }
}
