#ifndef __QTCLANGLECONTROL__
#define __QTCLANGLECONTROL__

#include <QWidget>
#include <QtDesigner/QDesignerExportWidget>

class QDESIGNER_WIDGET_EXPORT QTclAngleControl : public QWidget {
  Q_OBJECT
  Q_PROPERTY( double alpha READ alpha WRITE setAlpha )
  Q_PROPERTY( double phi   READ phi   WRITE setPhi )
  Q_PROPERTY( double theta READ theta WRITE setTheta )
public:
  QTclAngleControl(QWidget *parent);
  double alpha() const { return _alpha; }
  double phi() const { return _phi; }
  double theta() const { return _theta; }
  QSizePolicy sizePolicy() const;
public slots:
  void setAlpha(double alpha);
  void setPhi(double phi);
  void setTheta(double theta);
signals:
  void changed();
protected:
  void paintEvent(QPaintEvent *);
  void mousePressEvent(QMouseEvent *e);
  void mouseMoveEvent(QMouseEvent *e);
  void wheelEvent (QWheelEvent * e);
private:
  double _alpha;
  double _phi;
  double _theta;
private:
  QPoint clickPos;
};

#endif
