#ifndef _QTCLDOMTREEVIEW_H_
#define _QTCLDOMTREEVIEW_H_

#include <QTreeWidget>
#include <QDomDocument>
#include <QtDesigner/QDesignerExportWidget>

class QDESIGNER_WIDGET_EXPORT QTclDOMTreeView : public QTreeWidget {
  Q_OBJECT
  Q_PROPERTY(bool pure READ pure WRITE setPure RESET unsetPure )
  Q_PROPERTY(bool showAttributes READ showAttributes WRITE setShowAttributes RESET unsetShowAttributes)
  Q_PROPERTY(int expansionDepth READ expansionDepth WRITE setExpansionDepth RESET unsetExpansionDepth)
  Q_PROPERTY(int textLimit READ textLimit WRITE setTextLimit RESET unsetTextLimit)
  Q_PROPERTY(QString text READ text WRITE setText DESIGNABLE false STORED false);
  Q_PROPERTY(QString filename READ filename WRITE setFilename DESIGNABLE false STORED false)
public: 
  QTclDOMTreeView(QWidget *parent);
  ~QTclDOMTreeView();
public slots:
  void refresh();
  void setPure(bool=TRUE);
  void unsetPure();
  void setShowAttributes(bool=TRUE);
  void unsetShowAttributes();
  void setExpansionDepth(int);
  void unsetExpansionDepth();
  void setFilename(const QString&);
  void setText(const QString&);
  bool search(const QString&);
  bool searchCase(const QString&);
  void setTextLimit(int);
  void unsetTextLimit();
  void unsetDocument();
public:
  bool pure() const;
  bool showAttributes() const;
  int expansionDepth() const;
  int textLimit() const;
  const QString& filename() const;
  QString text() const;
private:
  virtual QTreeWidgetItem *startElement(const QDomElement element, QTreeWidgetItem *parent);
  virtual QTreeWidgetItem *endElement(const QDomElement element,QTreeWidgetItem*parent,QTreeWidgetItem*after);
  virtual QTreeWidgetItem *textNode(QDomNode &node,QTreeWidgetItem*parent);
  QString _filename;
  int     _textLimit;
  QDomDocument _document;
  int _expansionDepth;
  bool _pure;
  bool _showAttributes;
  void showRecursive(QTreeWidgetItem *parentItem,QDomNode node,int depth);
  bool searchRecursive(QTreeWidgetItem *item,const QString &searchText,bool caseSensitive,bool all);
  void adjustDepth(QTreeWidgetItem *item,int currDepth);
};

#endif
