extern "C" {
#include <math.h>
};

#include <qstring.h>
#include <qpainter.h>
#include <qcolor.h>

#include "QTclUtil.h"

#include "QTclImageHistogram.h"


QTclImageHistogram::QTclImageHistogram(QWidget *parent) : QWidget(parent) {
  resetHistogramm();
  setMinimumWidth(256);
  setMinimumHeight(128);
  setSizePolicy(QSizePolicy(QSizePolicy::MinimumExpanding,QSizePolicy::MinimumExpanding));
}

void QTclImageHistogram::setImage(const QImage &image) {
  _image=image;
  resetHistogramm();
  if(!_image.isNull()) {
    updateHistogramm();
  }
  emit imageChanged(_image);
  repaint();            //widget neuzeichnen
}

void QTclImageHistogram::resetHistogramm() {
  for(int i=0;i<QTCLARSIZE(_histoArray);i++) _histoArray[i] = 0;
}

void QTclImageHistogram::updateHistogramm() {  
  int width = _image.width();
  int height = _image.height();
  if(width*height==0) return;
  double addvalue = 1.0 /(width*height); //Normierung
  // make histogramm
  for(int i=0; i<width; i++) {
    for(int j=0; j<height; j++) {
      int gray=qGray(_image.pixel(i,j));
      _histoArray[gray] +=addvalue;
    }
  }
  //search for max
  double maxGW = _histoArray[0];
  for(int i=1; i<QTCLARSIZE(_histoArray); i++) {
    if(_histoArray[i] > maxGW)
      maxGW = _histoArray[i];
  }
  if(maxGW==0.0) return;
  //scale Values to 0..1.0
  for(int i=0; i<QTCLARSIZE(_histoArray); i++) {
    _histoArray[i] *= (1.0/maxGW);
  }
}

void QTclImageHistogram::paintEvent(QPaintEvent * /*e*/) {
QPainter painter(this);
int w=width();
int h=height();
int n=QTCLARSIZE(_histoArray);
  painter.setBrush(palette().text());
  painter.scale(1.0,-1.0);
  painter.translate(0,-h);
  double bw=(w*1.0)/n;
  int width=(int)ceil(bw);
  for(int i=0;i<QTCLARSIZE(_histoArray);i++) {
    int x=(int)round(i*bw);
    int height=(int)round(_histoArray[i]*h);
    int y=0; //w-height;
    painter.drawRect(x,y,width,height);
  }
}

#include "moc_QTclImageHistogram.cpp"
