#ifndef __QTCLIMAGEHISTO_H__
#define __QTCLIMAGEHISTO_H__

#include <QWidget>
#include <QImage>
#include <QtDesigner/QDesignerExportWidget>

class QDESIGNER_WIDGET_EXPORT QTclImageHistogram : public QWidget {
  Q_OBJECT
  Q_PROPERTY( QImage image READ image WRITE setImage);
public:
  QTclImageHistogram(QWidget *parent=0);
  QImage image() const {return _image;} 
public slots:
  void setImage(const QImage &image);
signals:
  void imageChanged(const QImage &);
protected:
  void paintEvent(QPaintEvent *e);
private:
  void updateHistogramm();
  void resetHistogramm();
  QImage   _image;
  double    _histoArray[256];
};

#endif
