extern "C" {
#include <math.h>
};

#include <QtCore/QString>
#include <QtGui/QPainter>
#include <QtGui/QColor>

#include "QTclUtil.h"

#include "QTclImageViewer.h"

QTclImageViewer::QTclImageViewer(QWidget *parent) : QWidget(parent) {
  setFixedSize(0,0);
}

void QTclImageViewer::setImage(const QImage &image) {
  _image=image;
  setFixedSize(_image.width(),_image.height());
  repaint();
  emit imageChanged(_image);
}

void QTclImageViewer::paintEvent(QPaintEvent * /*e*/) {
QPainter painter(this);
  painter.drawImage(0,0,_image);
}

#include "moc_QTclImageViewer.cpp"
